/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import uk.org.primrose.SyslogDefs;
import uk.org.primrose.SyslogException;

public class Syslog {
    private static Syslog logger = null;
    private String logName;
    private String hostName;
    private int portNum;
    private int flags;
    private boolean includeDate;
    private InetAddress boundAddress;
    private DatagramSocket socket;
    private SimpleDateFormat date1Format;
    private SimpleDateFormat date2Format;

    public static void open(String hostname, String name, int flags) throws SyslogException {
        logger = new Syslog(hostname, 514, name, flags);
    }

    public static void log(int fac, int lvl, String msg) throws SyslogException {
        logger.syslog(fac, lvl, msg);
    }

    public static void close() {
        logger = null;
    }

    public Syslog(String name, int flags) throws SyslogException {
        this.logName = name;
        this.hostName = null;
        this.portNum = 514;
        this.flags = flags;
        this.initialize();
    }

    public Syslog(String hostname, int port, String name, int flags) throws SyslogException {
        this.logName = name;
        this.hostName = hostname;
        this.portNum = port;
        this.flags = flags;
        try {
            this.boundAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException ex) {
            String message = "error locating host named '" + hostname + "': " + ex.getMessage();
            throw new SyslogException(message);
        }
        this.initialize();
    }

    private void initialize() throws SyslogException {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException ex) {
            String message = "error creating syslog udp socket: " + ex.getMessage();
            throw new SyslogException(message);
        }
        this.includeDate = true;
        if (this.includeDate) {
            this.date1Format = new SimpleDateFormat("MMM  d HH:mm:ss ", Locale.US);
            this.date2Format = new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.US);
            this.date1Format.setTimeZone(TimeZone.getDefault());
            this.date2Format.setTimeZone(TimeZone.getDefault());
        }
    }

    public void syslog(int fac, int pri, String msg) throws SyslogException {
        this.syslog(this.boundAddress, this.portNum, fac, pri, msg);
    }

    public void syslog(InetAddress addr, int fac, int pri, String msg) throws SyslogException {
        this.syslog(addr, this.portNum, fac, pri, msg);
    }

    public void syslog(String hostname, int fac, int pri, String msg) throws SyslogException {
        try {
            InetAddress address = InetAddress.getByName(hostname);
            this.syslog(address, this.portNum, fac, pri, msg);
        }
        catch (UnknownHostException ex) {
            String message = "error locating host named '" + hostname + "': " + ex.getMessage();
            throw new SyslogException(message);
        }
    }

    public void syslog(String hostname, int port, int fac, int pri, String msg) throws SyslogException {
        try {
            InetAddress address = InetAddress.getByName(hostname);
            this.syslog(address, port, fac, pri, msg);
        }
        catch (UnknownHostException ex) {
            String message = "error locating host named '" + hostname + "': " + ex.getMessage();
            throw new SyslogException(message);
        }
    }

    public void syslog(InetAddress addr, int port, int fac, int pri, String msg) throws SyslogException {
        byte[] numbuf = new byte[32];
        int pricode = SyslogDefs.computeCode(fac, pri);
        Integer priObj = new Integer(pricode);
        String nmObj = this.logName != null ? new String(this.logName) : new String(Thread.currentThread().getName());
        int length = 4 + nmObj.length() + msg.length() + 1;
        length += pricode > 99 ? 3 : (pricode > 9 ? 2 : 1);
        String dStr = null;
        if (this.includeDate) {
            Calendar now = Calendar.getInstance();
            dStr = now.get(5) < 10 ? this.date1Format.format(now.getTime()) : this.date2Format.format(now.getTime());
            length += dStr.length();
        }
        byte[] data = new byte[length];
        int idx = 0;
        data[idx++] = 60;
        String strObj = Integer.toString(priObj);
        byte[] sBytes = strObj.getBytes();
        System.arraycopy(sBytes, 0, data, idx, sBytes.length);
        idx += sBytes.length;
        data[idx++] = 62;
        if (this.includeDate) {
            sBytes = dStr.getBytes();
            System.arraycopy(sBytes, 0, data, idx, sBytes.length);
            idx += sBytes.length;
        }
        sBytes = nmObj.getBytes();
        System.arraycopy(sBytes, 0, data, idx, sBytes.length);
        idx += sBytes.length;
        data[idx++] = 58;
        data[idx++] = 32;
        sBytes = msg.getBytes();
        System.arraycopy(sBytes, 0, data, idx, sBytes.length);
        data[idx += sBytes.length] = 0;
        DatagramPacket packet = new DatagramPacket(data, length, addr, port);
        try {
            this.socket.send(packet);
        }
        catch (IOException ex) {
            String message = "error sending message: '" + ex.getMessage() + "'";
            System.err.println(message);
            throw new SyslogException(message);
        }
        if ((this.flags & 0x20) != 0) {
            if (this.logName != null) {
                System.err.print(this.logName + ": ");
            } else {
                System.err.print(Thread.currentThread().getName() + ": ");
            }
            System.err.println(msg);
        }
    }
}

