/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.jndi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimroseContext
implements Context {
    Hashtable<String, Object> ht = new Hashtable();

    public PrimroseContext() throws NamingException {
    }

    public PrimroseContext(Hashtable<?, ?> env) throws NamingException {
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object o = this.ht.get(name);
        if (o == null) {
            String[] parts = name.split("/");
            Context ctx = (Context)this.ht.get(parts[0]);
            if (parts.length > 1) {
                for (int i = 1; i < parts.length - 1; ++i) {
                    ctx = (Context)ctx.lookup(parts[i]);
                }
                o = ctx.lookup(parts[parts.length - 1]);
            }
        }
        if (o == null) {
            throw new NamingException("Cannot find JNDI resource under name : " + name);
        }
        return o;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (this.ht.get(name) != null) {
            throw new NameAlreadyBoundException(name + " is already bound under this context");
        }
        this.ht.put(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.ht.remove(obj);
        this.ht.put(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.ht.remove(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        PrimroseContext ctx = new PrimroseContext();
        this.ht.put(name, ctx);
        return ctx;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }
}

