/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core.loadrules;

import uk.org.primrose.Logger;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.loadrules.LoadRule;
import uk.org.primrose.pool.core.loadrules.LoadRuleException;

public class FailoverPool
implements LoadRule {
    public void runCheck(Pool pool, Logger logger) throws LoadRuleException {
        logger.info("[Pool@" + pool.getPoolName() + "] Checking 'failoverPool' rule  ...");
        if (pool.getOnExceptionCheckSQL() == null || pool.getOnExceptionCheckSQL().length() == 0) {
            throw new LoadRuleException("Pool config parameter 'onExceptionCheckSQL' must be specified if you wish to use the 'failoverPool' parameter.");
        }
        if (pool.getDumpConnectionOnSQLException() == null || !pool.getDumpConnectionOnSQLException().equalsIgnoreCase("true")) {
            throw new LoadRuleException("Pool config parameter 'dumpConnectionOnSQLException' must be set to 'true' if you wish to use the 'failoverPool' parameter. (dumpConnectionOnSQLException=" + pool.getDumpConnectionOnSQLException() + ")");
        }
        if (pool.getWaitForConnectionIfDatabaseIsDown().equalsIgnoreCase("true")) {
            throw new LoadRuleException("Pool config parameter 'waitForConnectionIfDatabaseIsDown' must be set to 'false' if you wish to use the 'failoverPool' parameter. (waitForConnectionIfDatabaseIsDown=" + pool.getWaitForConnectionIfDatabaseIsDown() + ")");
        }
    }
}

