/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.datasource;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import uk.org.primrose.pool.PoolException;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.PoolLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimroseDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = -3545935342768603717L;
    private String poolName = "";

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Pool pool = PoolLoader.findExistingPool(this.poolName);
        if (pool == null) {
            throw new SQLException("Cannot find primrose pool under name '" + this.poolName + "'");
        }
        try {
            return pool.getConnection();
        }
        catch (PoolException pe) {
            pool.getLogger().printStackTrace(pe);
            throw new SQLException(pe.toString());
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() {
        return -1;
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Unimplemented in Primrose 3.0.14");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Unimplemented in Primrose 3.0.14");
    }
}

