/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.test;

import java.util.Properties;
import uk.org.primrose.GeneralException;
import uk.org.primrose.pool.core.ExternalPoolConfigProvider;

public class ExamplePoolConfigProvider
implements ExternalPoolConfigProvider {
    Properties poolOneProps = new Properties();
    Properties poolTwoProps = new Properties();

    public ExamplePoolConfigProvider() {
        this.poolOneProps.put("base", "10");
        this.poolOneProps.put("log", "C:/java/primrose_3.0/poolone_${yyyy-MM-dd}.log");
        this.poolOneProps.put("logLevel", "verbose,info,warn,error,crisis");
        this.poolOneProps.put("driverClass", "oracle.jdbc.driver.OracleDriver");
        this.poolOneProps.put("driverURL", "jdbc:oracle:thin:@192.168.154.3:1521:EXHCDEV1");
        this.poolOneProps.put("user", "hcr");
        this.poolOneProps.put("password", "dev");
        this.poolOneProps.put("killActiveConnectionsOverAge", "120000");
        this.poolOneProps.put("cycleConnections", "1000");
        this.poolOneProps.put("connectionAutoCommit", "true");
        this.poolOneProps.put("checkSQL", "select 1 from dual");
        this.poolOneProps.put("connectionTransactionIsolation", "TRANSACTION_READ_COMMITTED");
        this.poolTwoProps.put("base", "5");
        this.poolTwoProps.put("log", "C:/java/primrose_3.0/pooltwo_${yyyy-MM-dd}.log");
        this.poolTwoProps.put("idleTime", "5000");
        this.poolTwoProps.put("logLevel", "info,warn,error,crisis");
        this.poolTwoProps.put("driverClass", "oracle.jdbc.driver.OracleDriver");
        this.poolTwoProps.put("driverURL", "jdbc:oracle:thin:@192.168.154.3:1521:EXHCDEV1");
        this.poolTwoProps.put("user", "oraquery");
        this.poolTwoProps.put("password", "dev");
        this.poolTwoProps.put("killActiveConnectionsOverAge", "120000");
    }

    public String getConfigItem(String poolName, String itemName) throws GeneralException {
        if (poolName.equals("poolOne")) {
            return this.poolOneProps.getProperty(itemName);
        }
        if (poolName.equals("poolTwo")) {
            return this.poolTwoProps.getProperty(itemName);
        }
        throw new GeneralException("Unknown pool name :'" + poolName + "'");
    }
}

