/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.vendor.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.JDBCExceptionReporter;
import uk.org.primrose.GeneralException;
import uk.org.primrose.pool.PoolException;
import uk.org.primrose.pool.core.ExternalPoolConfigProvider;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.PoolLoader;
import uk.org.primrose.vendor.standalone.PrimroseLoader;

public class PrimroseConnectionProvider
implements ConnectionProvider,
ExternalPoolConfigProvider {
    private static Map<String, Properties> poolConfigurations = null;
    private String poolName;

    public PrimroseConnectionProvider() {
        if (poolConfigurations == null) {
            poolConfigurations = new HashMap<String, Properties>();
        }
    }

    public void configure(Properties props) throws HibernateException {
        this.poolName = (String)props.get("hibernate.primrose.poolName");
        if (this.poolName == null) {
            throw new HibernateException("Unknown pool name. Please ensure property hibernate.primrose.poolName is set in your configuration.");
        }
        Properties poolConfiguration = null;
        if (poolConfigurations.containsKey(this.poolName)) {
            poolConfiguration = poolConfigurations.get(this.poolName);
        } else {
            poolConfiguration = new Properties();
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("hibernate.primrose.")) continue;
                String primroseKey = key.replace("hibernate.primrose.", "");
                poolConfiguration.put(primroseKey, props.get(key));
            }
        }
        try {
            poolConfigurations.put(this.poolName, poolConfiguration);
            PrimroseLoader.load(poolConfiguration, true);
        }
        catch (Throwable e) {
            throw new HibernateException(e);
        }
    }

    public Connection getConnection() throws SQLException {
        Pool pool = PoolLoader.findExistingPool(this.poolName);
        if (pool == null) {
            throw new SQLException("Cannot find primrose pool under name '" + this.poolName + "'");
        }
        try {
            return pool.getConnection();
        }
        catch (PoolException e) {
            pool.getLogger().printStackTrace(e);
            throw new SQLException("Cannot obtain connection using pool name '" + this.poolName + "'");
        }
    }

    public void closeConnection(Connection con) throws SQLException {
        try {
            con.close();
        }
        catch (SQLException ex) {
            JDBCExceptionReporter.logExceptions((SQLException)ex);
            throw ex;
        }
    }

    public void close() {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public String getConfigItem(String poolName, String itemName) throws GeneralException {
        Properties poolConfiguration;
        if (poolConfigurations.containsKey(poolName) && (poolConfiguration = poolConfigurations.get(poolName)) != null) {
            return poolConfiguration.getProperty(itemName);
        }
        return null;
    }
}

