/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.vendor.standalone;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import uk.org.primrose.GeneralException;
import uk.org.primrose.pool.PoolException;
import uk.org.primrose.pool.core.PoolLoader;
import uk.org.primrose.pool.datasource.PrimroseDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimroseLoader {
    public static void main(String[] args) throws Exception, Throwable {
        if (args.length != 1) {
            System.out.println("java uk.org.primrose.vendor.standalone.PrimroseLoader <config file>");
            System.exit(0);
        }
        PrimroseLoader.load(args[0], true);
    }

    public static void stopPool(String name) throws PoolException {
        PoolLoader.stopPool(name);
    }

    public static void stopAllPools() throws PoolException {
        PoolLoader.stopAllPools();
    }

    public static List<String> load(String configFile, boolean createNewPools) throws GeneralException, IOException {
        PrimroseLoader.setJNDIEnv();
        List<String> loadedPoolNames = PoolLoader.loadPool(configFile, createNewPools);
        for (String poolName : loadedPoolNames) {
            PrimroseLoader.bindPoolToJNDI(poolName);
        }
        return loadedPoolNames;
    }

    public static void load(Properties config, boolean createNewPools) throws GeneralException {
        PrimroseLoader.setJNDIEnv();
        String poolName = PoolLoader.loadPool(config, createNewPools);
        PrimroseLoader.bindPoolToJNDI(poolName);
    }

    private static void bindPoolToJNDI(String poolName) throws GeneralException {
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup("java:comp");
            Context envCtx = null;
            try {
                envCtx = (Context)ctx.lookup("env");
            }
            catch (NamingException e) {
                envCtx = ctx.createSubcontext("env");
            }
            PrimroseDataSource pds = new PrimroseDataSource();
            pds.setPoolName(poolName);
            envCtx.rebind(poolName, (Object)pds);
        }
        catch (Exception e) {
            throw new GeneralException("Error creating JNDI subcontext 'env', while loading pool '" + poolName + "'", e);
        }
    }

    private static void setJNDIEnv() {
        System.setProperty("java.naming.factory.url.pkgs", "uk.org.primrose.jndi");
        System.setProperty("java.naming.factory.initial", "uk.org.primrose.jndi.PrimroseInitialContextFactory");
    }
}

