/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.sql;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;

public abstract class NativeSQLQueryNonScalarReturn
implements NativeSQLQueryReturn,
Serializable {
    private final String alias;
    private final LockMode lockMode;
    private final Map propertyResults = new HashMap();
    private final int hashCode;

    protected NativeSQLQueryNonScalarReturn(String alias, Map propertyResults, LockMode lockMode) {
        this.alias = alias;
        if (alias == null) {
            throw new HibernateException("alias must be specified");
        }
        this.lockMode = lockMode;
        if (propertyResults != null) {
            this.propertyResults.putAll(propertyResults);
        }
        int hashCode = alias.hashCode();
        hashCode = 29 * hashCode + lockMode.toString().hashCode();
        if (propertyResults != null) {
            hashCode = 29 * hashCode + ((Object)propertyResults).hashCode();
        }
        this.hashCode = hashCode;
    }

    public String getAlias() {
        return this.alias;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public Map getPropertyResultsMap() {
        return Collections.unmodifiableMap(this.propertyResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeSQLQueryNonScalarReturn that = (NativeSQLQueryNonScalarReturn)o;
        return this.alias.equals(that.alias) && this.lockMode.toString().equals(that.lockMode.toString()) && (this.propertyResults == null && that.propertyResults == null || this.propertyResults != null && ((Object)this.propertyResults).equals(that.propertyResults));
    }

    public int hashCode() {
        return this.hashCode;
    }
}

