/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.OperationCounter;

abstract class Operation
implements Runnable {
    private Object[] mArguments;
    private boolean mCompleted;
    private OperationCounter mCounter;
    private Throwable mException;
    private Object mReturnValue;
    private Thread mThread;

    Operation(OperationCounter counter, Object[] arguments) {
        this.mArguments = arguments;
        this.mCounter = counter;
        this.mCompleted = false;
        if (null != this.mCounter) {
            this.mCounter.increment();
        }
    }

    public final void run() {
        this.mThread = Thread.currentThread();
        try {
            this.mReturnValue = this.process(this.mArguments);
        }
        catch (Throwable ex) {
            this.mException = ex;
        }
        this.mCompleted = true;
        if (null != this.mCounter) {
            this.mCounter.decrement();
        }
    }

    final boolean completed() {
        return this.mCompleted;
    }

    final Object getArgument(int index) {
        return this.mArguments[index];
    }

    final Object[] getArguments() {
        return this.mArguments;
    }

    final Throwable getException() {
        return this.mException;
    }

    final Object getReturnValue() {
        return this.mReturnValue;
    }

    final Thread getThread() {
        return this.mThread;
    }

    abstract Object process(Object[] var1) throws Throwable;

    final void reset() {
        this.mCompleted = false;
        this.mException = null;
        this.mReturnValue = null;
        this.mThread = null;
    }
}

