/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static XMLUtil sMe;
    private Transformer mTransform;
    private DocumentBuilder mBuilder;

    private XMLUtil() throws MessagingException {
        this.initBuilder();
        this.initTransform();
    }

    public static XMLUtil getInstance() throws MessagingException {
        if (sMe == null) {
            sMe = new XMLUtil();
        }
        return sMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document newDocument() {
        DocumentBuilder documentBuilder = this.mBuilder;
        synchronized (documentBuilder) {
            return this.mBuilder.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readDocument(InputStream in) throws IOException {
        try {
            DocumentBuilder documentBuilder = this.mBuilder;
            synchronized (documentBuilder) {
                return this.mBuilder.parse(in);
            }
        }
        catch (SAXException saxEx) {
            throw new IOException(saxEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document doc, OutputStream out) throws IOException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        try {
            Transformer transformer = this.mTransform;
            synchronized (transformer) {
                this.mTransform.transform(source, result);
            }
        }
        catch (TransformerException tEx) {
            throw new IOException(tEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asString(Document doc) throws MessagingException {
        DOMSource source = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            Transformer transformer = this.mTransform;
            synchronized (transformer) {
                this.mTransform.transform(source, result);
            }
        }
        catch (TransformerException tEx) {
            throw new MessagingException(tEx.getMessage());
        }
        return writer.toString();
    }

    private void initTransform() throws MessagingException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            this.mTransform = tf.newTransformer();
        }
        catch (TransformerFactoryConfigurationError tfcEx) {
            throw new MessagingException((Throwable)tfcEx);
        }
        catch (TransformerConfigurationException cfgEx) {
            throw new MessagingException((Throwable)cfgEx);
        }
    }

    private void initBuilder() throws MessagingException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            this.mBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pEx) {
            throw new MessagingException((Throwable)pEx);
        }
        catch (FactoryConfigurationError fEx) {
            throw new MessagingException((Throwable)fEx);
        }
    }
}

