/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.app;

import ise.library.GUIUtils;
import ise.library.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AntelopeGUILogHandler
extends Handler {
    private JTextPane _text;
    private boolean _tail = true;
    private JPanel _content_pane;
    private JFrame _frame;
    private Color GREEN = new Color(0, 153, 51);
    private Font _font = null;

    public AntelopeGUILogHandler() {
        this(false);
    }

    public AntelopeGUILogHandler(boolean bl) {
        Log.log("AntelopeGUILogHandler constructor");
        this._content_pane = new JPanel(new BorderLayout());
        this._text = new JTextPane();
        this._text.setCaretPosition(0);
        this._content_pane.add((Component)new JScrollPane(this._text), "Center");
        this._content_pane.add((Component)this.getControlPanel(), "South");
        if (bl) {
            this._frame = new JFrame("Antelope Logger");
            this._frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    AntelopeGUILogHandler.this._frame.setVisible(false);
                }
            });
            this._frame.getContentPane().add(this._content_pane);
            this._frame.setSize(600, 400);
            GUIUtils.centerOnScreen(this._frame);
        }
        this.setFormatter(new LogFormatter());
    }

    public JTextComponent getTextComponent() {
        return this._text;
    }

    public Document getDocument() {
        return this._text.getDocument();
    }

    public JPanel getPanel() {
        return this._content_pane;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public void setVisible(boolean bl) {
        this._frame.setVisible(bl);
    }

    public void dispose() {
        this._frame.dispose();
    }

    public void setLocation(int n, int n2) {
        this._frame.setLocation(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._frame.setBounds(n, n2, n3, n4);
    }

    public Dimension getSize() {
        return this._frame.getSize();
    }

    public void close() {
        if (this.getFormatter() != null) {
            this.publish(new LogRecord(Level.INFO, this.getFormatter().getTail(this)));
        }
    }

    public void flush() {
    }

    public void open() {
        Log.log("gui log handler.open");
        if (this.getFormatter() != null) {
            int n = this._text.getDocument().getLength();
            try {
                this._text.getDocument().insertString(n, this.getFormatter().getHead(this), null);
            }
            catch (Exception exception) {
                Log.log(exception);
            }
        }
    }

    public void publish(final LogRecord logRecord) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = logRecord.getMessage();
                    if (string == null) {
                        return;
                    }
                    if (AntelopeGUILogHandler.this.getFormatter() != null) {
                        string = AntelopeGUILogHandler.this.getFormatter().format(logRecord);
                    }
                    if (AntelopeGUILogHandler.this._text == null) {
                        return;
                    }
                    try {
                        int n = AntelopeGUILogHandler.this._text.getDocument().getLength();
                        int n2 = AntelopeGUILogHandler.this._text.getCaretPosition();
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        if (AntelopeGUILogHandler.this._font == null) {
                            StyleConstants.setFontFamily(simpleAttributeSet, "Monospaced");
                        } else {
                            StyleConstants.setFontFamily(simpleAttributeSet, AntelopeGUILogHandler.this._font.getFamily());
                            StyleConstants.setBold(simpleAttributeSet, AntelopeGUILogHandler.this._font.isBold());
                            StyleConstants.setItalic(simpleAttributeSet, AntelopeGUILogHandler.this._font.isItalic());
                            StyleConstants.setFontSize(simpleAttributeSet, AntelopeGUILogHandler.this._font.getSize());
                        }
                        if (logRecord.getLevel().equals(Level.WARNING)) {
                            StyleConstants.setForeground(simpleAttributeSet, AntelopeGUILogHandler.this.GREEN);
                        } else if (logRecord.getLevel().equals(Level.SEVERE)) {
                            StyleConstants.setForeground(simpleAttributeSet, Color.RED);
                        } else if (logRecord.getLevel().equals(Level.INFO)) {
                            StyleConstants.setForeground(simpleAttributeSet, Color.BLUE);
                        }
                        AntelopeGUILogHandler.this._text.getDocument().insertString(n, string, simpleAttributeSet);
                        if (AntelopeGUILogHandler.this._tail) {
                            AntelopeGUILogHandler.this._text.setCaretPosition(n + string.length());
                        } else {
                            AntelopeGUILogHandler.this._text.setCaretPosition(n2);
                        }
                    }
                    catch (Exception exception) {
                        Log.log(exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }

    private JPanel getControlPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        final JCheckBox jCheckBox = new JCheckBox("Tail");
        jCheckBox.setSelected(true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopeGUILogHandler.this._tail = jCheckBox.isSelected();
                if (AntelopeGUILogHandler.this._tail) {
                    AntelopeGUILogHandler.this._text.setCaretPosition(AntelopeGUILogHandler.this._text.getDocument().getLength());
                }
            }
        });
        jPanel.add(jCheckBox);
        return jPanel;
    }

    public class LogFormatter
    extends Formatter {
        public String format(LogRecord logRecord) {
            return logRecord.getMessage() + System.getProperty("line.separator");
        }
    }
}

