/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.app;

import ise.antelope.app.AntelopeSyntaxUtilities;
import ise.antelope.app.StyleEditor;
import ise.antelope.app.jedit.SyntaxStyle;
import ise.library.GUIUtils;
import ise.library.KappaLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SyntaxChooser
extends JDialog {
    private JButton ok_btn;
    private StyleButton comment1_disp = null;
    private StyleButton comment2_disp = null;
    private StyleButton keyword1_disp = null;
    private StyleButton keyword2_disp = null;
    private StyleButton keyword3_disp = null;
    private StyleButton literal1_disp = null;
    private StyleButton literal2_disp = null;
    private StyleButton label_disp = null;
    private StyleButton operator_disp = null;
    private StyleButton invalid_disp = null;
    private SyntaxStyle[] styles = null;

    private SyntaxChooser(JFrame jFrame) {
        super(jFrame);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Syntax Highlighting");
        JLabel jLabel = new JLabel("Comment 1");
        JLabel jLabel2 = new JLabel("Comment 2");
        JLabel jLabel3 = new JLabel("Tag name");
        JLabel jLabel4 = new JLabel("Attribute");
        JLabel jLabel5 = new JLabel("Inside PI");
        JLabel jLabel6 = new JLabel("String");
        JLabel jLabel7 = new JLabel("String");
        JLabel jLabel8 = new JLabel("Entity");
        JLabel jLabel9 = new JLabel("Operator");
        JLabel jLabel10 = new JLabel("Invalid");
        SyntaxStyle[] syntaxStyleArray = AntelopeSyntaxUtilities.getStoredStyles();
        this.comment1_disp = new StyleButton("comment", syntaxStyleArray[1]);
        this.comment2_disp = new StyleButton("comment", syntaxStyleArray[2]);
        this.keyword1_disp = new StyleButton("target ", syntaxStyleArray[6]);
        this.keyword2_disp = new StyleButton("name", syntaxStyleArray[7]);
        this.keyword3_disp = new StyleButton("some text", syntaxStyleArray[8]);
        this.literal1_disp = new StyleButton("\"some text\"", syntaxStyleArray[3]);
        this.literal2_disp = new StyleButton("'some text'", syntaxStyleArray[4]);
        this.label_disp = new StyleButton("&amp;", syntaxStyleArray[5]);
        this.operator_disp = new StyleButton("=", syntaxStyleArray[9]);
        this.invalid_disp = new StyleButton("invalid", syntaxStyleArray[10]);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleButton styleButton = (StyleButton)actionEvent.getSource();
                StyleEditor styleEditor = new StyleEditor(SyntaxChooser.this, styleButton.getStyle());
                SyntaxStyle syntaxStyle = styleEditor.getStyle();
                if (syntaxStyle != null) {
                    styleButton.setStyle(syntaxStyle);
                }
            }
        };
        this.comment1_disp.addActionListener(actionListener);
        this.comment2_disp.addActionListener(actionListener);
        this.keyword1_disp.addActionListener(actionListener);
        this.keyword2_disp.addActionListener(actionListener);
        this.keyword3_disp.addActionListener(actionListener);
        this.literal1_disp.addActionListener(actionListener);
        this.literal2_disp.addActionListener(actionListener);
        this.label_disp.addActionListener(actionListener);
        this.operator_disp.addActionListener(actionListener);
        this.invalid_disp.addActionListener(actionListener);
        KappaLayout kappaLayout = new KappaLayout();
        JPanel jPanel = new JPanel(kappaLayout);
        this.setContentPane(jPanel);
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel.add((Component)jLabel, "0, 0, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel2, "0, 1, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel3, "0, 2, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel4, "0, 3, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel5, "0, 4, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel6, "0, 5, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel7, "0, 6, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel8, "0, 7, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel9, "0, 8, 1, 1, W, wh, 0");
        jPanel.add((Component)jLabel10, "0, 9, 1, 1, W, wh, 0");
        jPanel.add((Component)this.comment1_disp, "1, 0, 1, 1, W, wh, 0");
        jPanel.add((Component)this.comment2_disp, "1, 1, 1, 1, W, wh, 0");
        jPanel.add((Component)this.keyword1_disp, "1, 2, 1, 1, W, wh, 0");
        jPanel.add((Component)this.keyword2_disp, "1, 3, 1, 1, W, wh, 0");
        jPanel.add((Component)this.keyword3_disp, "1, 4, 1, 1, W, wh, 0");
        jPanel.add((Component)this.literal1_disp, "1, 5, 1, 1, W, wh, 0");
        jPanel.add((Component)this.literal2_disp, "1, 6, 1, 1, W, wh, 0");
        jPanel.add((Component)this.label_disp, "1, 7, 1, 1, W, wh, 0");
        jPanel.add((Component)this.operator_disp, "1, 8, 1, 1, W, wh, 0");
        jPanel.add((Component)this.invalid_disp, "1, 9, 1, 1, W, wh, 0");
        kappaLayout.makeColumnsSameWidth(0, 1);
        kappaLayout = new KappaLayout();
        JPanel jPanel2 = new JPanel(kappaLayout);
        this.ok_btn = new JButton("OK");
        JButton jButton = new JButton("Cancel");
        jPanel2.add((Component)this.ok_btn, "0, 0, 1, 1, 0, wh, 3");
        jPanel2.add((Component)jButton, "1, 0, 1, 1, 0, wh, 3");
        kappaLayout.makeColumnsSameWidth(0, 1);
        jPanel.add((Component)jPanel2, "0, 10, 2, 1, 0, , 6");
        this.ok_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxChooser.access$002(SyntaxChooser.this, AntelopeSyntaxUtilities.getStoredStyles());
                ((SyntaxChooser)SyntaxChooser.this).styles[1] = SyntaxChooser.this.comment1_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[2] = SyntaxChooser.this.comment2_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[6] = SyntaxChooser.this.keyword1_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[7] = SyntaxChooser.this.keyword2_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[8] = SyntaxChooser.this.keyword3_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[3] = SyntaxChooser.this.literal1_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[4] = SyntaxChooser.this.literal2_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[5] = SyntaxChooser.this.label_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[9] = SyntaxChooser.this.operator_disp.getStyle();
                ((SyntaxChooser)SyntaxChooser.this).styles[10] = SyntaxChooser.this.invalid_disp.getStyle();
                AntelopeSyntaxUtilities.storeStyles(SyntaxChooser.this.styles);
                SyntaxChooser.this.setVisible(false);
                SyntaxChooser.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxChooser.access$002(SyntaxChooser.this, null);
                SyntaxChooser.this.setVisible(false);
                SyntaxChooser.this.dispose();
            }
        });
        this.pack();
        GUIUtils.center(jFrame, this);
        this.setVisible(true);
    }

    public SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public static SyntaxChooser showDialog(JFrame jFrame) {
        SyntaxChooser syntaxChooser = new SyntaxChooser(jFrame);
        return syntaxChooser;
    }

    static /* synthetic */ SyntaxStyle[] access$002(SyntaxChooser syntaxChooser, SyntaxStyle[] syntaxStyleArray) {
        syntaxChooser.styles = syntaxStyleArray;
        return syntaxStyleArray;
    }

    public class StyleButton
    extends JButton {
        private SyntaxStyle style;

        public StyleButton(String string, SyntaxStyle syntaxStyle) {
            super(string);
            this.style = null;
            this.setStyle(syntaxStyle);
        }

        public void setStyle(SyntaxStyle syntaxStyle) {
            this.style = syntaxStyle;
            this.setForeground(syntaxStyle.getColor());
            this.setBackground(Color.white);
            this.setFont(syntaxStyle.getStyledFont(this.getFont()));
        }

        public SyntaxStyle getStyle() {
            return this.style;
        }
    }
}

