/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.AntelopePanel;
import ise.antelope.common.CommonHelper;
import ise.antelope.common.OptionSettings;
import ise.library.GUIUtils;
import ise.library.KappaLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class AntelopeOptions
extends JPanel {
    private CommonHelper _helper;
    private static OptionSettings settings;
    private JLabel build_file;
    private JCheckBox cb_auto_reload;
    private JCheckBox cba;
    private JCheckBox cba2;
    private JCheckBox cba3;
    private JCheckBox cb00;
    private JCheckBox cb0;
    private JCheckBox cb1;
    private JCheckBox cb1a;
    private JCheckBox cb1b;
    private JCheckBox cb2;
    private JCheckBox cb3;
    private JCheckBox cb4;
    private JCheckBox cb5;
    private JCheckBox cb6;
    private JCheckBox cb7;
    private LevelRadioButton lrb0;
    private LevelRadioButton lrb1;
    private LevelRadioButton lrb2;
    private LevelRadioButton lrb3;
    private LevelRadioButton lrb4;
    private static HashMap _dialogs;
    private static HashMap _options;
    ActionListener lrb_al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LevelRadioButton levelRadioButton = (LevelRadioButton)actionEvent.getSource();
            settings.setMessageOutputLevel(levelRadioButton.getLevel());
        }
    };

    public static AntelopeOptions showDialog(AntelopePanel antelopePanel, CommonHelper commonHelper) {
        JDialog jDialog = (JDialog)_dialogs.get(antelopePanel);
        if (jDialog == null) {
            final AntelopePanel antelopePanel2 = antelopePanel;
            AntelopeOptions antelopeOptions = new AntelopeOptions(antelopePanel2, commonHelper);
            JFrame jFrame = GUIUtils.getRootJFrame(antelopePanel2);
            final JDialog jDialog2 = new JDialog(jFrame, "Antelope Options", false);
            _dialogs.put(antelopePanel, jDialog2);
            _options.put(jDialog2, antelopeOptions);
            jDialog = jDialog2;
            JPanel jPanel = new JPanel(new KappaLayout());
            jDialog2.setContentPane(jPanel);
            jPanel.add((Component)antelopeOptions, "0,0,1,1");
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog2.setVisible(false);
                    jDialog2.dispose();
                    settings.save();
                    antelopePanel2.reload();
                }
            });
            JButton jButton2 = new JButton("Apply");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    settings.save();
                    antelopePanel2.reload();
                }
            });
            JButton jButton3 = new JButton("Cancel");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog2.setVisible(false);
                    jDialog2.dispose();
                }
            });
            KappaLayout kappaLayout = new KappaLayout();
            JPanel jPanel2 = new JPanel(kappaLayout);
            jPanel2.add((Component)jButton, "0, 0, 1, 1, 0, w, 3");
            jPanel2.add((Component)jButton2, "1, 0, 1, 1, 0, w, 3");
            jPanel2.add((Component)jButton3, "2, 0, 1, 1, 0, w, 3");
            kappaLayout.makeColumnsSameWidth();
            jPanel.add((Component)jPanel2, "0, 1, 1, 1, 1, 0, 0, 5");
            jDialog2.pack();
            if (jFrame != null) {
                GUIUtils.center(jFrame, jDialog2);
            } else {
                GUIUtils.centerOnScreen(jDialog2);
            }
        }
        jDialog.setVisible(true);
        return (AntelopeOptions)_options.get(jDialog);
    }

    private AntelopeOptions(AntelopePanel antelopePanel, CommonHelper commonHelper) {
        final AntelopePanel antelopePanel2 = antelopePanel;
        this._helper = commonHelper;
        settings = new OptionSettings(antelopePanel2.getBuildFile());
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add((Component)jTabbedPane, "Center");
        KappaLayout.Constraints constraints = KappaLayout.createConstraint();
        constraints.a = 7;
        constraints.s = "w";
        JPanel jPanel = new JPanel(new KappaLayout());
        jPanel.setPreferredSize(new Dimension(400, 250));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        if (this._helper != null && this._helper.canSaveBeforeRun()) {
            this.cba = new JCheckBox("Save all files before running targets");
            this.cba.setSelected(settings.getSaveBeforeRun());
            this.cba.setToolTipText("<html>If checked, all files will be saved<br>before running any target.");
            this.cba.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    settings.setSaveBeforeRun(jCheckBox.isSelected());
                }
            });
            ++constraints.y;
            jPanel.add((Component)this.cba, constraints);
            this.cba2 = new JCheckBox("Use error parsing");
            this.cba2.setSelected(settings.getUseErrorParsing());
            this.cba2.setToolTipText("<html>If checked, errors generated during target execution\nwill be displayed in the Error List.");
            this.cba2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    settings.setUseErrorParsing(jCheckBox.isSelected());
                }
            });
            ++constraints.y;
            jPanel.add((Component)this.cba2, constraints);
        }
        this.cba3 = new JCheckBox("Show performance statistics");
        this.cba3.setSelected(settings.getShowPerformanceOutput());
        this.cba3.setToolTipText("<html>If checked, execution time for each task and\ntarget will be displayed following the build output.");
        this.cba3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowPerformanceOutput(jCheckBox.isSelected());
            }
        });
        ++constraints.y;
        jPanel.add((Component)this.cba3, constraints);
        this.cb_auto_reload = new JCheckBox("Automatically reload build file");
        this.cb_auto_reload.setSelected(settings.getAutoReload());
        this.cb_auto_reload.setToolTipText("<html>If checked, the build file will be reloaded\nprior to running any targets.");
        this.cb_auto_reload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setAutoReload(jCheckBox.isSelected());
            }
        });
        ++constraints.y;
        jPanel.add((Component)this.cb_auto_reload, constraints);
        constraints.y = 0;
        JPanel jPanel2 = new JPanel(new KappaLayout());
        jPanel2.setBorder(new EmptyBorder(6, 6, 6, 6));
        JLabel jLabel = new JLabel("Show subtargets:");
        this.cb00 = new JCheckBox("Show all targets");
        this.cb00.setSelected(settings.getShowAllTargets());
        this.cb00.setToolTipText("Show all targets");
        this.cb00.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowAllTargets(jCheckBox.isSelected());
                AntelopeOptions.this.cb0.setEnabled(!jCheckBox.isSelected());
                AntelopeOptions.this.cb1.setEnabled(!jCheckBox.isSelected());
                AntelopeOptions.this.cb1a.setEnabled(!jCheckBox.isSelected());
            }
        });
        this.cb0 = new JCheckBox("Show targets without descriptions");
        this.cb0.setSelected(settings.getShowTargetsWODesc());
        this.cb0.setToolTipText("<html>If checked, targets without descriptions will be shown.<br>Typically, only top-level targets have descriptions.");
        this.cb0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowTargetsWODesc(jCheckBox.isSelected());
            }
        });
        this.cb1 = new JCheckBox("Show targets with dots");
        this.cb1.setSelected(settings.getShowTargetsWDot());
        this.cb1.setToolTipText("<html>If checked, targets with dots in their names will be shown.<br>A fairly common practice is to name subtargets using 'dot'<br>notation, e.g. 'clean.apidocs'.");
        this.cb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowTargetsWDot(jCheckBox.isSelected());
            }
        });
        this.cb1a = new JCheckBox("Show targets with dash");
        this.cb1a.setSelected(settings.getShowTargetsWDash());
        this.cb1a.setToolTipText("<html>If checked, targets with names starting with a dash will be shown.<br>A common practice is to name subtargets using a dash at the start<br>e.g. '-clean.apidocs'.");
        this.cb1a.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowTargetsWDash(jCheckBox.isSelected());
            }
        });
        this.cb1b = new JCheckBox("Sort target buttons");
        this.cb1b.setSelected(settings.getSortTargets());
        this.cb1b.setToolTipText("<html>If checked, the target buttons will be sorted alphabetically by target name.");
        this.cb1b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setSortTargets(jCheckBox.isSelected());
            }
        });
        ++constraints.y;
        jPanel2.add((Component)jLabel, constraints);
        ++constraints.y;
        jPanel2.add((Component)this.cb00, constraints);
        ++constraints.y;
        jPanel2.add((Component)this.cb0, constraints);
        ++constraints.y;
        jPanel2.add((Component)this.cb1, constraints);
        ++constraints.y;
        jPanel2.add((Component)this.cb1a, constraints);
        ++constraints.y;
        jPanel2.add((Component)this.cb1b, constraints);
        JPanel jPanel3 = new JPanel(new KappaLayout());
        jPanel3.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.lrb0 = new LevelRadioButton("Errors", 0);
        this.lrb1 = new LevelRadioButton("Warnings", 1);
        this.lrb2 = new LevelRadioButton("Information", 2);
        this.lrb3 = new LevelRadioButton("Verbose", 3);
        this.lrb4 = new LevelRadioButton("Debug", 4);
        switch (settings.getMessageOutputLevel()) {
            case 0: {
                this.lrb0.setSelected(true);
                break;
            }
            case 1: {
                this.lrb1.setSelected(true);
                break;
            }
            default: {
                this.lrb2.setSelected(true);
                break;
            }
            case 3: {
                this.lrb3.setSelected(true);
                break;
            }
            case 4: {
                this.lrb4.setSelected(true);
            }
        }
        this.lrb0.addActionListener(this.lrb_al);
        this.lrb1.addActionListener(this.lrb_al);
        this.lrb2.addActionListener(this.lrb_al);
        this.lrb3.addActionListener(this.lrb_al);
        this.lrb4.addActionListener(this.lrb_al);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lrb0);
        buttonGroup.add(this.lrb1);
        buttonGroup.add(this.lrb2);
        buttonGroup.add(this.lrb3);
        buttonGroup.add(this.lrb4);
        JLabel jLabel2 = new JLabel("Set message level:");
        constraints.y = 0;
        jPanel3.add((Component)jLabel2, constraints);
        ++constraints.y;
        jPanel3.add((Component)this.lrb0, constraints);
        ++constraints.y;
        jPanel3.add((Component)this.lrb1, constraints);
        ++constraints.y;
        jPanel3.add((Component)this.lrb2, constraints);
        ++constraints.y;
        jPanel3.add((Component)this.lrb3, constraints);
        ++constraints.y;
        jPanel3.add((Component)this.lrb4, constraints);
        JPanel jPanel4 = new JPanel(new KappaLayout());
        jPanel4.setBorder(new EmptyBorder(6, 6, 6, 6));
        JLabel jLabel3 = new JLabel("Show message events:");
        this.cb2 = new JCheckBox("Build events");
        this.cb3 = new JCheckBox("Target events");
        this.cb4 = new JCheckBox("Task events");
        this.cb5 = new JCheckBox("Log events");
        this.cb2.setSelected(settings.getShowBuildEvents());
        this.cb3.setSelected(settings.getShowTargetEvents());
        this.cb4.setSelected(settings.getShowTaskEvents());
        this.cb5.setSelected(settings.getShowLogMessages());
        this.cb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowBuildEvents(jCheckBox.isSelected());
            }
        });
        this.cb3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowTargetEvents(jCheckBox.isSelected());
            }
        });
        this.cb4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowTaskEvents(jCheckBox.isSelected());
            }
        });
        this.cb5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowLogMessages(jCheckBox.isSelected());
            }
        });
        constraints.y = 0;
        jPanel4.add((Component)jLabel3, constraints);
        ++constraints.y;
        jPanel4.add((Component)this.cb2, constraints);
        ++constraints.y;
        jPanel4.add((Component)this.cb3, constraints);
        ++constraints.y;
        jPanel4.add((Component)this.cb4, constraints);
        ++constraints.y;
        jPanel4.add((Component)this.cb5, constraints);
        JPanel jPanel5 = new JPanel(new KappaLayout());
        jPanel5.setBorder(new EmptyBorder(6, 6, 6, 6));
        JLabel jLabel4 = new JLabel("Antelope Appearance:");
        this.cb6 = new JCheckBox("Show button text");
        this.cb7 = new JCheckBox("Show button icon");
        this.cb6.setSelected(settings.getShowButtonText());
        this.cb7.setSelected(settings.getShowButtonIcon());
        this.cb6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowButtonText(jCheckBox.isSelected());
                antelopePanel2.showButtonText(jCheckBox.isSelected());
            }
        });
        this.cb7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                settings.setShowButtonIcon(jCheckBox.isSelected());
                antelopePanel2.showButtonIcon(jCheckBox.isSelected());
            }
        });
        constraints.y = 0;
        jPanel5.add((Component)jLabel4, constraints);
        ++constraints.y;
        jPanel5.add((Component)this.cb6, constraints);
        ++constraints.y;
        jPanel5.add((Component)this.cb7, constraints);
        jTabbedPane.add("General", jPanel);
        jTabbedPane.add("Targets", jPanel2);
        jTabbedPane.add("Messages", jPanel3);
        jTabbedPane.add("Events", jPanel4);
        jTabbedPane.add("Appearance", jPanel5);
    }

    protected void reset(String string) {
        String string2 = "<none>";
        if (string != null) {
            string2 = string;
        }
        this.build_file.setText(string2);
        this.cba.setSelected(settings.getSaveBeforeRun());
        this.cba2.setSelected(settings.getUseErrorParsing());
        this.cba3.setSelected(settings.getShowPerformanceOutput());
        this.cb1.setSelected(settings.getShowTargetsWDot());
        this.cb0.setSelected(settings.getShowTargetsWODesc());
        this.cb2.setSelected(settings.getShowBuildEvents());
        this.cb3.setSelected(settings.getShowTargetEvents());
        this.cb4.setSelected(settings.getShowTaskEvents());
        this.cb5.setSelected(settings.getShowLogMessages());
        switch (settings.getMessageOutputLevel()) {
            case 0: {
                this.lrb0.setSelected(true);
                break;
            }
            case 1: {
                this.lrb1.setSelected(true);
                break;
            }
            default: {
                this.lrb2.setSelected(true);
                break;
            }
            case 3: {
                this.lrb3.setSelected(true);
                break;
            }
            case 4: {
                this.lrb4.setSelected(true);
            }
        }
    }

    static {
        _dialogs = new HashMap();
        _options = new HashMap();
    }

    class LevelRadioButton
    extends JRadioButton {
        private int _level;

        public LevelRadioButton(String string, int n) {
            super(string);
            this._level = 0;
            this._level = n;
        }

        public int getLevel() {
            return this._level;
        }
    }
}

