/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.SAXTreeNode;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class SAXNodeHandler
extends DefaultHandler {
    private Locator locator = null;
    private Locator docLocator = null;
    private Stack stack = new Stack();
    private SAXTreeNode rootNode = null;
    private File infile = null;
    private boolean isImported = false;
    private HashMap propertyFiles = null;
    private HashMap antProperties = new HashMap();
    private Logger _logger = Logger.getLogger("ise.antelope.Antelope");
    private List default_taskList = Arrays.asList("propertyfile", "importtypelib", "vsscheckin", "sql", "cvspass", "p4reopen", "csc", "dirname", "wlrun", "p4label", "p4revert", "replaceregexp", "get", "jjtree", "sleep", "jarlib-display", "dependset", "zip", "patch", "jspc", "style", "test", "tstamp", "unwar", "vsshistory", "icontract", "cvschangelog", "p4submit", "ccmcheckin", "p4change", "bzip2", "sync", "p4delete", "vssadd", "javadoc", "p4integrate", "translate", "signjar", "cclock", "chown", "vajload", "jarlib-available", "WsdlToDotnet", "buildnumber", "jpcovmerge", "ejbjar", "war", "rename", "sequential", "serverdeploy", "property", "subant", "move", "ildasm", "copydir", "cccheckin", "ccunlock", "wljspc", "fixcrlf", "sosget", "pathconvert", "record", "p4sync", "exec", "ccmklabel", "p4edit", "manifest", "maudit", "antlr", "netrexxc", "jpcovreport", "execon", "ccmcheckout", "ant", "xmlvalidate", "xslt", "p4resolve", "iplanet-ejbc", "ccmcheckintask", "gzip", "native2ascii", "ccrmtype", "starteam", "ear", "input", "presetdef", "rmic", "checksum", "mail", "loadfile", "vsscheckout", "stylebook", "soscheckin", "mimemail", "stlabel", "gunzip", "concat", "cab", "touch", "parallel", "splash", "antcall", "ccmkbl", "cccheckout", "typedef", "p4have", "filter", "xmlproperty", "import", "copy", "jsharpc", "symlink", "antstructure", "script", "ccmcreatetask", "rpm", "delete", "replace", "mmetrics", "attrib", "waitfor", "untar", "loadproperties", "available", "echoproperties", "chgrp", "vajexport", "bunzip2", "whichresource", "copyfile", "p4labelsync", "vsscreate", "macrodef", "ejbc", "unjar", "vbc", "wsdltodotnet", "mkdir", "condition", "cvs", "tempfile", "junitreport", "taskdef", "echo", "ccupdate", "java", "vsslabel", "renameext", "basename", "javadoc2", "tar", "vsscp", "vajimport", "p4fstat", "setproxy", "p4counter", "wlstop", "ilasm", "soscheckout", "apply", "ccuncheckout", "jarlib-resolve", "jlink", "cvstagdiff", "javacc", "chmod", "pvcs", "jarlib-manifest", "jar", "ccmklbtype", "sound", "scriptdef", "defaultexcludes", "mparse", "blgenclient", "uptodate", "jjdoc", "genkey", "javah", "ccmreconfigure", "fail", "unzip", "javac", "p4add", "jpcoverage", "soslabel", "depend", "vssget", "deltree", "ddcreator");
    private List default_typeList = Arrays.asList("patternset", "assertions", "propertyset", "filterset", "libfileset", "filterreader", "scriptfilter", "extension", "fileset", "dirset", "filelist", "filterchain", "path", "classfileset", "selector", "xmlcatalog", "description", "mapper", "zipfileset", "substitution", "extensionSet", "regexp");
    private List taskList = this.default_taskList;
    private List typeList = this.default_typeList;

    public SAXNodeHandler() {
        this(null);
    }

    public SAXNodeHandler(File file) {
        this(file, false);
    }

    public SAXNodeHandler(File file, boolean bl) {
        this.infile = file;
        this.isImported = bl;
        this.init();
    }

    private void init() {
        Properties properties;
        try {
            properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties"));
            this.taskList = Collections.list(properties.propertyNames());
        }
        catch (Exception exception) {
            this.taskList = this.default_taskList;
        }
        try {
            properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("org/apache/tools/ant/types/defaults.properties"));
            this.typeList = Collections.list(properties.propertyNames());
        }
        catch (Exception exception) {
            this.typeList = this.default_typeList;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public SAXTreeNode getRoot() {
        return this.rootNode;
    }

    public void startDocument() {
        this.docLocator = new LocatorImpl(this.locator);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            Object object;
            Enumeration<?> enumeration;
            Cloneable cloneable;
            Object object2;
            Object object3;
            SAXTreeNode sAXTreeNode;
            block33: {
                int n;
                LocatorImpl locatorImpl = new LocatorImpl(this.locator);
                sAXTreeNode = new SAXTreeNode(string3, new Point(locatorImpl.getLineNumber(), locatorImpl.getColumnNumber()), attributes);
                sAXTreeNode.setImported(this.isImported);
                this.setKind(string3, sAXTreeNode);
                if (locatorImpl.getSystemId() != null && locatorImpl.getSystemId().startsWith("file:")) {
                    String string4 = locatorImpl.getSystemId();
                    if (string4.startsWith("file:")) {
                        string4 = string4.substring("file:".length());
                    }
                    if (!((File)(object3 = new File(string4))).exists() && this.infile != null) {
                        object2 = this.infile;
                        if (!((File)object2).isDirectory()) {
                            object2 = ((File)object2).getParentFile();
                        }
                        object3 = new File((File)object2, ((File)object3).getName());
                    }
                    sAXTreeNode.setFile((File)object3);
                } else if (this.infile != null) {
                    sAXTreeNode.setFile(this.infile);
                }
                if (string3.equals("import") && (n = attributes.getIndex("file")) > -1) {
                    object3 = attributes.getValue(n);
                    object2 = new File((String)(object3 = this.resolveValue((String)object3)));
                    if (!((File)object2).exists()) {
                        object2 = new File(this.infile.getParent(), (String)object3);
                    }
                    if (((File)object2).exists()) {
                        try {
                            cloneable = this.getRoot();
                            enumeration = this.locator;
                            object = this.docLocator;
                            File file = this.infile;
                            boolean bl = this.isImported;
                            this.infile = object2;
                            this.isImported = true;
                            InputSource inputSource = new InputSource(new FileReader((File)object2));
                            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                            SAXNodeHandler sAXNodeHandler = new SAXNodeHandler((File)object2, true);
                            sAXParser.parse(inputSource, (DefaultHandler)sAXNodeHandler);
                            sAXTreeNode = sAXNodeHandler.getRoot();
                            this.rootNode = cloneable;
                            this.locator = enumeration;
                            this.docLocator = object;
                            this.infile = file;
                            this.isImported = bl;
                        }
                        catch (Exception exception) {
                            enumeration = new StringBuffer();
                            ((StringBuffer)((Object)enumeration)).append("<html>Error loading imported file: ").append(((File)object2).getAbsolutePath()).append("<br>");
                            ((StringBuffer)((Object)enumeration)).append("at line number: ").append(locatorImpl.getLineNumber()).append(", col number: ").append(locatorImpl.getColumnNumber()).append("<p>");
                            ((StringBuffer)((Object)enumeration)).append("The specific error is: ").append(exception.getMessage()).append("<p>");
                            ((StringBuffer)((Object)enumeration)).append("Do you want to load the rest of the file?");
                            int n2 = JOptionPane.showConfirmDialog(null, ((StringBuffer)((Object)enumeration)).toString(), "Error loading build file", 0);
                            if (n2 != 1) break block33;
                            throw new SAXException(exception);
                        }
                    }
                }
            }
            if (string3.equals("property")) {
                String string5 = null;
                if (sAXTreeNode.getAttributeValue("name") != null) {
                    object3 = sAXTreeNode.getAttributeValue("name");
                    if (sAXTreeNode.getAttributeValue("value") != null) {
                        string5 = sAXTreeNode.getAttributeValue("value");
                    } else if (sAXTreeNode.getAttributeValue("location") != null) {
                        string5 = sAXTreeNode.getAttributeValue("location");
                    }
                    string5 = this.resolveValue(string5);
                    if (string5 != null) {
                        this.antProperties.put(object3, string5);
                    }
                } else if (sAXTreeNode.getAttributeValue("file") != null) {
                    object3 = sAXTreeNode.getAttributeValue("file");
                    object2 = new File((String)(object3 = this.resolveValue((String)object3)));
                    if (!((File)object2).exists()) {
                        object2 = new File(this.infile.getParent(), (String)object3);
                    }
                    if (((File)object2).exists()) {
                        cloneable = new Properties();
                        try {
                            ((Properties)cloneable).load(new FileInputStream((File)object2));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        enumeration = ((Properties)cloneable).propertyNames();
                        while (enumeration.hasMoreElements()) {
                            object = (String)enumeration.nextElement();
                            string5 = ((Properties)cloneable).getProperty((String)object);
                            if ((string5 = this.resolveValue(string5)) == null) continue;
                            this.antProperties.put(object, string5);
                        }
                    }
                }
            }
            if (string3.equals("property") && sAXTreeNode.getAttributeValue("file") != null) {
                this.addPropertyFile(sAXTreeNode, "file");
            } else if (string3.equals("loadproperties") && sAXTreeNode.getAttributeValue("srcfile") != null) {
                this.addPropertyFile(sAXTreeNode, "srcfile");
            }
            if (this.stack.empty()) {
                this.rootNode = sAXTreeNode;
            } else {
                SAXTreeNode sAXTreeNode2 = (SAXTreeNode)this.stack.peek();
                sAXTreeNode2.add(sAXTreeNode);
                if (sAXTreeNode.isTarget()) {
                    object3 = sAXTreeNode2.getAttributeValue("default");
                    object2 = sAXTreeNode.getAttributeValue("name");
                    if (object3 != null && object2 != null && ((String)object3).equals(object2)) {
                        sAXTreeNode.setDefaultTarget(true);
                    }
                }
            }
            this.stack.push(sAXTreeNode);
        }
        catch (SAXException sAXException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>Error loading build file ");
            stringBuffer.append("at line number: ").append(this.locator.getLineNumber()).append(", col number: ").append(this.locator.getColumnNumber()).append("<p>");
            stringBuffer.append("The specific error is: ").append(sAXException.getMessage()).append("<p>");
            throw new SAXException(stringBuffer.toString());
        }
    }

    private String resolveValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\\$\\{.*?\\}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find(n)) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuffer.append(string.substring(n, n2));
            String string3 = string.substring(n2 + 2, n3 - 1);
            String string4 = (String)this.antProperties.get(string3);
            if (string4 == null) {
                string4 = System.getProperty(string3);
            }
            stringBuffer.append(string4 == null ? "${" + string3 + "}" : string4);
            n = n3;
        }
        return stringBuffer.toString() + string.substring(n);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
    }

    public InputSource resolveEntity(String string, String string2) {
        if (string2 != null) {
            File file;
            if (string2.toLowerCase().startsWith("http")) {
                try {
                    InputSource inputSource = new InputSource(new URL(string2).openStream());
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<html>Error loading included resource: ").append(string2).append("<br>");
                    stringBuffer.append("at line number: ").append(this.locator.getLineNumber()).append(", col number: ").append(this.locator.getColumnNumber()).append("<p>");
                    stringBuffer.append("The specific error is: ").append(exception.getMessage()).append("<p>");
                    stringBuffer.append("Do you want to load the rest of the file?");
                    int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), "Error loading build file", 0);
                    if (n == 1) {
                        throw new RuntimeException(exception);
                    }
                    return null;
                }
            }
            String string3 = new String(string2);
            if (string3.startsWith("file:")) {
                string3 = string3.substring("file:".length());
            }
            if (string3.startsWith("..")) {
                if (this.infile == null) {
                    return null;
                }
                file = !this.infile.isDirectory() ? new File(this.infile.getParentFile().getParentFile(), string3.substring(2)) : new File(this.infile.getParentFile(), string3.substring(2));
            } else {
                file = new File(string3);
                if (!file.exists()) {
                    if (this.infile == null) {
                        return null;
                    }
                    file = !this.infile.isDirectory() ? new File(this.infile.getParentFile(), string3) : new File(this.infile, string3);
                }
            }
            if (file.exists()) {
                try {
                    InputSource inputSource = new InputSource(new FileReader(file));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<html>Error loading included resource: ").append(string2).append("<br>");
                    stringBuffer.append("at line number: ").append(this.locator.getLineNumber()).append(", col number: ").append(this.locator.getColumnNumber()).append("<p>");
                    stringBuffer.append("The specific error is: ").append(exception.getMessage()).append("<p>");
                    stringBuffer.append("Do you want to load the rest of the file?");
                    int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), "Error loading build file", 0);
                    if (n == 1) {
                        throw new RuntimeException(exception);
                    }
                    return null;
                }
            }
            try {
                InputSource inputSource = new InputSource(new URL(string2).openStream());
                inputSource.setPublicId(string);
                inputSource.setSystemId(string2);
                return inputSource;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>Error loading included resource: ").append(string2).append("<br>");
                stringBuffer.append("at line number: ").append(this.locator.getLineNumber()).append(", col number: ").append(this.locator.getColumnNumber()).append("<p>");
                stringBuffer.append("The specific error is: ").append(exception.getMessage()).append("<p>");
                stringBuffer.append("Do you want to load the rest of the file?");
                int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), "Error loading build file", 0);
                if (n == 1) {
                    throw new RuntimeException(exception);
                }
                return null;
            }
        }
        return null;
    }

    private void setKind(String string, SAXTreeNode sAXTreeNode) {
        if (string.equals("project")) {
            sAXTreeNode.setProject(true);
        } else if (string.equals("target")) {
            sAXTreeNode.setTarget(true);
        } else if (this.taskList.contains(string)) {
            sAXTreeNode.setTask(true);
        } else if (this.typeList.contains(string)) {
            sAXTreeNode.setType(true);
        }
    }

    private void addPropertyFile(SAXTreeNode sAXTreeNode, String string) {
        String string2;
        File file;
        if (this.propertyFiles == null) {
            this.propertyFiles = new HashMap();
        }
        if (!(file = new File(string2 = sAXTreeNode.getAttributeValue(string))).exists() && sAXTreeNode.getFile() != null) {
            file = new File(sAXTreeNode.getFile().getParentFile(), string2);
        }
        if (file.exists()) {
            this.propertyFiles.put(file, new Long(file.lastModified()));
        } else {
            this.propertyFiles.put(string2, new Long(0L));
        }
    }

    public HashMap getPropertyFiles() {
        return this.propertyFiles;
    }
}

