/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.AssertException;
import ise.antelope.tasks.AssertLevel;
import ise.antelope.tasks.BooleanConditionTask;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Assert
extends Task
implements TaskContainer {
    private boolean failOnError = true;
    private boolean failOnErrorSetByUser = false;
    private String execute = null;
    private boolean exists = true;
    private String value = null;
    private String name = null;
    private String message = "";
    private int level = 0;
    private Task condition_task = null;
    private Vector tasks = new Vector();

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            return;
        }
        this.message = string;
    }

    public void setExists(String string) {
        this.getProject();
        this.exists = Project.toBoolean((String)string);
    }

    public void setExecute(String string) {
        this.execute = string;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
        this.failOnErrorSetByUser = true;
    }

    public void setLevel(AssertLevel assertLevel) {
        this.level = assertLevel.indexOfValue(assertLevel.getValue());
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof BooleanConditionTask) {
            if (this.condition_task == null) {
                this.condition_task = task;
                return;
            }
            throw new BuildException("Only one <bool> or <condition> allowed per Assert.");
        }
        this.tasks.addElement(task);
    }

    public void addBool(BooleanConditionTask booleanConditionTask) {
        this.addTask((Task)booleanConditionTask);
    }

    public void execute() throws BuildException {
        block37: {
            block36: {
                String string;
                if (!this.failOnErrorSetByUser) {
                    switch (this.level) {
                        default: {
                            this.failOnError = true;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            this.failOnError = false;
                        }
                    }
                }
                if ((string = this.getProject().getProperty("ant.enable.asserts")) == null) break block36;
                this.getProject();
                if (Project.toBoolean((String)string)) break block37;
            }
            this.executeNestedTasks();
            return;
        }
        if (this.condition_task == null) {
            String string;
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            String string2 = this.getProject().getProperty(this.name);
            if (this.exists && string2 == null) {
                string = "Assertion failed: Property '" + this.name + "' doesn't exist in this project.\n" + this.message;
                if (this.failOnError) {
                    throw new BuildException(string);
                }
                this.log(string, 1);
            } else if (!this.exists && string2 != null) {
                string = "Assertion failed: Property '" + this.name + "' exists in this project, but shouldn't.\n" + this.message;
                if (this.failOnError) {
                    throw new BuildException(string);
                }
                this.log(string, 1);
            }
            if (this.value != null) {
                if (string2 == null) {
                    string = "Assertion failed: Expected '" + this.value + "', but was null\n" + this.message;
                    if (this.failOnError) {
                        throw new AssertException(string, this.level);
                    }
                    this.log(string, 1);
                } else if (string2 != null) {
                    string = string2.toLowerCase();
                    boolean bl = false;
                    if (string.equals("on") || string.equals("yes") || string.equals("true") || string.equals("off") || string.equals("no") || string.equals("false")) {
                        bl = true;
                    }
                    if (bl) {
                        this.getProject();
                        boolean bl2 = Project.toBoolean((String)string2);
                        this.getProject();
                        boolean bl3 = Project.toBoolean((String)this.value);
                        if (bl2 != bl3) {
                            String string3 = "Assertion failed: Expected '" + bl3 + "', but was '" + bl2 + "'.\n" + this.message;
                            if (this.failOnError) {
                                throw new AssertException(string3, this.level);
                            }
                            this.log(string3, 1);
                        }
                    } else if (!string2.equals(this.value)) {
                        String string4 = "Assertion failed: Expected '" + this.value + "', but was '" + string2 + "'.\n" + this.message;
                        if (this.failOnError) {
                            throw new AssertException(string4, this.level);
                        }
                        this.log(string4, 1);
                    }
                }
            }
        } else if (!((BooleanConditionTask)this.condition_task).eval()) {
            if (this.message == null) {
                this.message = "Assertion failed.";
            }
            if (this.failOnError) {
                throw new AssertException(this.message, this.level);
            }
            this.log(this.message, 1);
        }
        boolean bl = true;
        if (this.execute == null) {
            this.execute = this.getProject().getProperty("assert.execute");
            if (this.execute != null) {
                this.getProject();
                bl = Project.toBoolean((String)this.execute);
            }
        } else {
            this.getProject();
            bl = Project.toBoolean((String)this.execute);
        }
        if (bl) {
            this.executeNestedTasks();
        }
    }

    private void executeNestedTasks() {
        Enumeration enumeration = this.tasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            task.perform();
        }
    }

    public static int runTests() {
        Project project = new Project();
        Assert assert_ = new Assert();
        assert_.setProject(project);
        String string = "test_property";
        String string2 = "test_value";
        project.setProperty("ant.enable.asserts", "true");
        int n = 0;
        try {
            assert_.execute();
            throw new RuntimeException("test 1 failed.");
        }
        catch (Exception exception) {
            ++n;
            try {
                assert_.setName(string);
                assert_.execute();
                throw new RuntimeException("test 2 test failed.");
            }
            catch (Exception exception2) {
                ++n;
                try {
                    project.setProperty(string, string2);
                    assert_.setName(string);
                    assert_.execute();
                    ++n;
                }
                catch (Exception exception3) {
                    throw new RuntimeException("test 3 test failed:\n" + exception3.getMessage());
                }
                try {
                    assert_.setExists("false");
                    assert_.execute();
                    throw new RuntimeException("test 4 failed");
                }
                catch (Exception exception4) {
                    ++n;
                    try {
                        assert_.setExists("true");
                        assert_.setValue(string2);
                        assert_.execute();
                        ++n;
                    }
                    catch (Exception exception5) {
                        throw new RuntimeException("test 5 failed\n" + exception5.getMessage());
                    }
                    try {
                        assert_.setValue("blah");
                        assert_.execute();
                        throw new RuntimeException("test 6 failed");
                    }
                    catch (Exception exception6) {
                        ++n;
                        try {
                            assert_.setExists("true");
                            project.setProperty("boolean prop", "true");
                            assert_.setName("boolean prop");
                            assert_.setValue("tRue");
                            assert_.execute();
                            ++n;
                            assert_.setValue("on");
                            assert_.execute();
                            ++n;
                            assert_.setValue("Yes");
                            assert_.execute();
                            ++n;
                        }
                        catch (Exception exception7) {
                            throw new RuntimeException("test 7 failed\n" + exception7.getMessage());
                        }
                        try {
                            assert_.setValue("blah");
                            assert_.setFailonerror(false);
                            assert_.execute();
                            ++n;
                        }
                        catch (Exception exception8) {
                            throw new RuntimeException("test 10 failed");
                        }
                        try {
                            assert_.setValue("blah");
                            assert_.setFailonerror(true);
                            assert_.execute();
                            throw new RuntimeException("test 11 failed");
                        }
                        catch (Exception exception9) {
                            return ++n;
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = Assert.runTests();
        System.out.println("Ran " + n + " tests, all passed.");
    }
}

