/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.typedefs.TimeUnit;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Limit
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private long maxwait = 180L;
    protected TimeUnit unit = TimeUnit.SECOND_UNIT;
    private String timeoutProperty = null;
    private String timeoutValue = "true";
    private Task currentTask = null;
    private Thread taskRunner = null;
    private boolean failOnError = false;
    private Exception exception = null;

    public void addTask(Task task) throws BuildException {
        this.tasks.addElement(task);
    }

    public void setMaxwait(int n) {
        this.maxwait = n;
    }

    public void setUnit(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("second")) {
            this.setMaxWaitUnit(TimeUnit.SECOND_UNIT);
            return;
        }
        if (string.equals("millisecond")) {
            this.setMaxWaitUnit(TimeUnit.MILLISECOND_UNIT);
            return;
        }
        if (string.equals("minute")) {
            this.setMaxWaitUnit(TimeUnit.MINUTE_UNIT);
            return;
        }
        if (string.equals("hour")) {
            this.setMaxWaitUnit(TimeUnit.HOUR_UNIT);
            return;
        }
        if (string.equals("day")) {
            this.setMaxWaitUnit(TimeUnit.DAY_UNIT);
            return;
        }
        if (string.equals("week")) {
            this.setMaxWaitUnit(TimeUnit.WEEK_UNIT);
            return;
        }
    }

    public void setMilliseconds(int n) {
        this.setMaxwait(n);
        this.setMaxWaitUnit(TimeUnit.MILLISECOND_UNIT);
    }

    public void setSeconds(int n) {
        this.setMaxwait(n);
        this.setMaxWaitUnit(TimeUnit.SECOND_UNIT);
    }

    public void setMinutes(int n) {
        this.setMaxwait(n);
        this.setMaxWaitUnit(TimeUnit.MINUTE_UNIT);
    }

    public void setHours(int n) {
        this.setMaxwait(n);
        this.setMaxWaitUnit(TimeUnit.HOUR_UNIT);
    }

    public void setDays(int n) {
        this.setMaxwait(n);
        this.setMaxWaitUnit(TimeUnit.DAY_UNIT);
    }

    public void setWeeks(int n) {
        this.setMaxwait(n);
        this.setMaxWaitUnit(TimeUnit.WEEK_UNIT);
    }

    public void setMaxWaitUnit(TimeUnit timeUnit) {
        this.unit = timeUnit;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setProperty(String string) {
        this.timeoutProperty = string;
    }

    public void setValue(String string) {
        this.timeoutValue = string;
    }

    public void execute() throws BuildException {
        try {
            Thread thread;
            this.taskRunner = thread = new Thread(){

                public void run() {
                    Enumeration enumeration = Limit.this.tasks.elements();
                    while (enumeration.hasMoreElements() && Limit.this.taskRunner == this) {
                        Limit.this.currentTask = (Task)enumeration.nextElement();
                        try {
                            Limit.this.currentTask.perform();
                        }
                        catch (Exception exception) {
                            if (Limit.this.failOnError) {
                                Limit.this.exception = exception;
                                return;
                            }
                            Limit.this.exception = exception;
                        }
                    }
                }
            };
            thread.start();
            thread.join(this.unit.toMillis(this.maxwait));
            if (thread.isAlive()) {
                this.taskRunner = null;
                thread.interrupt();
                int n = this.tasks.indexOf(this.currentTask);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n + 1; i < this.tasks.size(); ++i) {
                    stringBuffer.append('<').append(((Task)this.tasks.get(i)).getTaskName()).append('>');
                    if (i >= this.tasks.size() - 1) continue;
                    stringBuffer.append(", ");
                }
                if (this.timeoutProperty != null) {
                    this.getProject().setNewProperty(this.timeoutProperty, this.timeoutValue);
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Interrupted task <").append(this.currentTask.getTaskName()).append(">. Waited ").append(this.maxwait).append(" ").append(this.unit.getValue()).append(", but this task did not complete.").append(stringBuffer.length() > 0 ? " The following tasks did not execute: " + stringBuffer.toString() + "." : "");
                if (this.failOnError) {
                    throw new BuildException(stringBuffer2.toString());
                }
                this.log(stringBuffer2.toString());
            } else if (this.failOnError && this.exception != null) {
                throw new BuildException((Throwable)this.exception);
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }
}

