/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.typedefs.Prop;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class PostTask
extends Task {
    private Hashtable props = new Hashtable();
    private URL to = null;
    private File propsFile = null;
    private String textProps = null;
    private String encoding = "UTF-8";
    private File log = null;
    private boolean append = true;
    private boolean verbose = true;
    private boolean wantResponse = true;
    private String property = null;
    private File outdir = null;
    private long maxwait = 180000L;
    private boolean failOnError = false;
    private static Hashtable cookieStorage = new Hashtable();
    private URLConnection connection = null;
    private Thread currentRunner = null;

    public void setTo(URL uRL) {
        this.to = uRL;
    }

    public void setOutdir(File file) {
        this.outdir = file;
        if (this.outdir != null && this.outdir.isFile()) {
            this.outdir = this.outdir.getParentFile();
        }
    }

    public void setFile(File file) {
        this.propsFile = file;
    }

    public void setLogfile(File file) {
        this.log = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setWantresponse(boolean bl) {
        this.wantResponse = bl;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setMaxwait(int n) {
        this.maxwait = n * 1000;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void addConfiguredProp(Prop prop) throws BuildException {
        String string = prop.getName();
        if (string == null) {
            throw new BuildException("name is null", this.getLocation());
        }
        String string2 = prop.getValue();
        if (string2 == null) {
            string2 = this.getProject().getProperty(string);
        }
        if (string2 == null) {
            throw new BuildException("value is null", this.getLocation());
        }
        this.props.put(string, string2);
    }

    public void addText(String string) {
        this.textProps = string;
    }

    public void execute() throws BuildException {
        block11: {
            if (this.to == null) {
                throw new BuildException("'to' attribute is required", this.getLocation());
            }
            final String string = this.getContent();
            try {
                if (this.verbose) {
                    this.log("Opening connection for post to " + this.to.toString() + "...");
                }
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FilterOutputStream filterOutputStream = null;
                        try {
                            PostTask.this.connection = PostTask.this.to.openConnection();
                            PostTask.this.connection.setDoInput(true);
                            PostTask.this.connection.setDoOutput(true);
                            PostTask.this.connection.setUseCaches(false);
                            PostTask.this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            Iterator iterator = cookieStorage.keySet().iterator();
                            while (iterator.hasNext()) {
                                StringBuffer stringBuffer = new StringBuffer();
                                Object k = iterator.next();
                                if (k == null) continue;
                                String string2 = k.toString();
                                Cookie cookie = (Cookie)cookieStorage.get(k);
                                if (!PostTask.this.to.getPath().startsWith(cookie.getPath())) continue;
                                PostTask.this.connection.addRequestProperty("Cookie", cookie.toString());
                                if (!PostTask.this.verbose) continue;
                                PostTask.this.log("Added cookie: " + cookie.toString());
                            }
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Connected, sending data...");
                            }
                            filterOutputStream = new DataOutputStream(PostTask.this.connection.getOutputStream());
                            if (PostTask.this.verbose) {
                                PostTask.this.log(string);
                            }
                            ((DataOutputStream)filterOutputStream).writeBytes(string);
                            ((DataOutputStream)filterOutputStream).flush();
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Data sent.");
                            }
                        }
                        catch (Exception exception) {
                            if (PostTask.this.failOnError) {
                                throw new BuildException((Throwable)exception, PostTask.this.getLocation());
                            }
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
                thread.start();
                thread.join(this.maxwait);
                if (thread.isAlive()) {
                    thread.interrupt();
                    if (this.failOnError) {
                        throw new BuildException("maxwait exceeded, unable to send data", this.getLocation());
                    }
                    return;
                }
                if (this.wantResponse) {
                    if (this.verbose) {
                        this.log("Waiting for response...");
                    }
                    this.currentRunner = thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PrintWriter printWriter = null;
                            StringWriter stringWriter = null;
                            PrintWriter printWriter2 = null;
                            FileOutputStream fileOutputStream = null;
                            BufferedInputStream bufferedInputStream = null;
                            byte[] byArray = new byte[8192];
                            File file = null;
                            try {
                                Object object;
                                if (PostTask.this.connection instanceof HttpURLConnection) {
                                    Object object2;
                                    Object object3;
                                    Object object4;
                                    Object object5;
                                    Map<String, List<String>> map = ((HttpURLConnection)PostTask.this.connection).getHeaderFields();
                                    object = map.keySet().iterator();
                                    while (object.hasNext()) {
                                        object5 = object.next();
                                        if (object5 == null || !((String)object5).equals("Set-Cookie")) continue;
                                        object4 = map.get(object5);
                                        object3 = object4.iterator();
                                        while (object3.hasNext()) {
                                            object2 = object3.next();
                                            Cookie cookie = new Cookie((String)object2);
                                            cookieStorage.put(cookie.getId(), cookie);
                                        }
                                    }
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log(String.valueOf(((HttpURLConnection)PostTask.this.connection).getResponseCode()));
                                        PostTask.this.log(((HttpURLConnection)PostTask.this.connection).getResponseMessage());
                                        map = ((HttpURLConnection)PostTask.this.connection).getHeaderFields();
                                        object = new StringBuffer();
                                        object5 = map.keySet().iterator();
                                        while (object5.hasNext()) {
                                            object4 = (String)object5.next();
                                            ((StringBuffer)object).append((String)object4).append("=");
                                            object3 = map.get(object4);
                                            if (object3 != null) {
                                                if (object3.size() == 1) {
                                                    ((StringBuffer)object).append(object3.get(0));
                                                } else if (object3.size() > 1) {
                                                    ((StringBuffer)object).append("[");
                                                    object2 = object3.iterator();
                                                    while (object2.hasNext()) {
                                                        ((StringBuffer)object).append(object2.next()).append(",");
                                                    }
                                                    ((StringBuffer)object).append("]");
                                                }
                                            }
                                            ((StringBuffer)object).append("\n");
                                            PostTask.this.log(((StringBuffer)object).toString());
                                        }
                                    }
                                    map = ((HttpURLConnection)PostTask.this.connection).getHeaderFields();
                                    object = map.get("Content-Type");
                                    object5 = null;
                                    if (object != null) {
                                        object5 = (String)object.get(0);
                                    }
                                    if (object5 != null && ((String)object5).equals("application/download")) {
                                        int n;
                                        if (PostTask.this.outdir == null) {
                                            PostTask.this.outdir = new File(PostTask.this.getProject().getProperty("basedir"));
                                        }
                                        if ((n = ((String)(object4 = map.get("Content-Disposition").get(0))).indexOf("filename=")) >= 0) {
                                            object2 = ((String)object4).substring(n + "filename=".length());
                                            object2 = ((String)object2).replaceAll("\"", "");
                                            file = new File(PostTask.this.outdir, (String)object2);
                                        }
                                    }
                                }
                                bufferedInputStream = new BufferedInputStream(PostTask.this.connection.getInputStream());
                                if (PostTask.this.log != null) {
                                    printWriter = new PrintWriter(new FileWriter(PostTask.this.log, PostTask.this.append));
                                }
                                if (PostTask.this.property != null) {
                                    stringWriter = new StringWriter();
                                    printWriter2 = new PrintWriter(stringWriter);
                                }
                                if (file != null) {
                                    fileOutputStream = new FileOutputStream(file);
                                }
                                int n = bufferedInputStream.read(byArray, 0, byArray.length);
                                while (n > -1) {
                                    object = new String(byArray, 0, n);
                                    if (PostTask.this.currentRunner != this) {
                                        break;
                                    }
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log((String)object);
                                    }
                                    if (printWriter != null) {
                                        printWriter.print((String)object);
                                    }
                                    if (printWriter2 != null) {
                                        printWriter2.print((String)object);
                                    }
                                    if (fileOutputStream != null) {
                                        fileOutputStream.write(byArray, 0, n);
                                    }
                                    n = bufferedInputStream.read(byArray, 0, byArray.length);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (PostTask.this.failOnError) {
                                    throw new BuildException((Throwable)exception, PostTask.this.getLocation());
                                }
                            }
                            finally {
                                try {
                                    bufferedInputStream.close();
                                }
                                catch (Exception exception) {}
                                try {
                                    if (printWriter != null) {
                                        printWriter.flush();
                                        printWriter.close();
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            if (PostTask.this.property != null && stringWriter != null) {
                                PostTask.this.getProject().setProperty(PostTask.this.property, stringWriter.toString());
                            }
                        }
                    };
                    thread.start();
                    thread.join(this.maxwait);
                    if (thread.isAlive()) {
                        this.currentRunner = null;
                        thread.interrupt();
                        if (this.failOnError) {
                            throw new BuildException("maxwait exceeded, unable to receive data", this.getLocation());
                        }
                    }
                }
                if (this.verbose) {
                    this.log("Post complete.");
                }
            }
            catch (Exception exception) {
                if (!this.failOnError) break block11;
                throw new BuildException((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block9: {
            Properties properties = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    this.addProperties(properties);
                } else {
                    this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
                }
                this.log("Post complete.");
            }
            catch (Exception exception) {
                if (!this.failOnError) break block9;
                throw new BuildException((Throwable)exception);
            }
        }
    }

    private String getContent() {
        StringBuffer stringBuffer;
        block5: {
            if (this.propsFile != null) {
                this.loadFile(this.propsFile);
            }
            if (this.textProps != null) {
                this.loadTextProps(this.textProps);
            }
            stringBuffer = new StringBuffer();
            try {
                Enumeration enumeration = this.props.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)this.props.get(string);
                    stringBuffer.append(URLEncoder.encode(string, this.encoding));
                    stringBuffer.append("=");
                    stringBuffer.append(URLEncoder.encode(string2, this.encoding));
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append("&");
                }
            }
            catch (IOException iOException) {
                if (!this.failOnError) break block5;
                throw new BuildException((Throwable)iOException, this.getLocation());
            }
        }
        return stringBuffer.toString();
    }

    private void loadTextProps(String string) {
        Properties properties = new Properties();
        Project project = this.getProject();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("{");
            int n2 = string4.indexOf("}");
            if (n <= -1 || n2 <= -1 || n2 <= n || (string3 = project.getProperty(string2 = string4.substring(n + 1, n2 - n))) == null) continue;
            properties.setProperty(string2, string3);
        }
        this.addProperties(properties);
    }

    private void addProperties(Properties properties) {
        this.resolveAllProperties(properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.props.put(string, string2);
        }
    }

    private void resolveAllProperties(Properties properties) throws BuildException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            boolean bl = false;
            while (!bl) {
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                ProjectHelper.parsePropertyString((String)string2, vector, vector2);
                bl = true;
                if (vector2.size() == 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration2 = vector.elements();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    if (string3 == null) {
                        String string4 = (String)enumeration3.nextElement();
                        if (string4.equals(string)) {
                            throw new BuildException("Property " + string + " was circularly " + "defined.");
                        }
                        string3 = this.getProject().getProperty(string4);
                        if (string3 == null) {
                            if (properties.containsKey(string4)) {
                                string3 = properties.getProperty(string4);
                                bl = false;
                            } else {
                                string3 = "${" + string4 + "}";
                            }
                        }
                    }
                    stringBuffer.append(string3);
                }
                string2 = stringBuffer.toString();
                properties.put(string, string2);
            }
        }
    }

    public class Cookie {
        private String name;
        private String value;
        private String domain;
        private String path = "/";
        private String id;

        public Cookie(String string) {
            String[] stringArray = string.split("[;]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.indexOf("=");
                if (n == -1) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1);
                if (i == 0) {
                    this.name = string3;
                    this.value = string4;
                    continue;
                }
                if (string3.equalsIgnoreCase("Path")) {
                    this.path = string4;
                    continue;
                }
                if (!string3.equalsIgnoreCase("Domain")) continue;
                this.domain = string4;
            }
            if (this.name == null) {
                throw new IllegalArgumentException("Raw cookie does not contain a cookie name.");
            }
            if (this.path == null) {
                this.path = "/";
            }
            this.setId(this.path, this.name);
        }

        public Cookie(String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("Cookie name may not be null.");
            }
            this.name = string;
            this.value = string2;
            this.setId(string);
        }

        public String getId() {
            if (this.id == null) {
                this.setId(this.path, this.name);
            }
            return this.id.toString();
        }

        private void setId(String string) {
            this.setId(this.path, string);
        }

        private void setId(String string, String string2) {
            if (string2 == null) {
                string2 = "";
            }
            this.id = string + string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setDomain(String string) {
            this.domain = string;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append("=").append(this.value).append(";");
            if (this.domain != null) {
                stringBuffer.append("Domain=").append(this.domain).append(";");
            }
            if (this.path != null) {
                stringBuffer.append("Path=").append(this.path).append(";");
            }
            stringBuffer.append("Version=\"1\";");
            return stringBuffer.toString();
        }
    }
}

