/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.condition;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.IsTrue;

public class DateTimeBefore
extends IsTrue
implements Condition {
    private String date1;
    private String date2;
    private String format = null;
    private boolean lenient = true;

    public void setDatetime1(String string) {
        if (string == null) {
            return;
        }
        if (this.date1 == null) {
            this.date1 = string;
        }
    }

    public void setDatetime2(String string) {
        if (string == null) {
            return;
        }
        if (this.date2 == null) {
            this.date2 = string;
        }
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean eval() throws BuildException {
        try {
            if (this.format == null) {
                throw new BuildException("format is required");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
            simpleDateFormat.setLenient(this.lenient);
            if (this.date1 == null || this.date2 == null) {
                throw new BuildException("Both datetime1 and datetime2 must be set.");
            }
            Date date = simpleDateFormat.parse(this.date1);
            Date date2 = simpleDateFormat.parse(this.date2);
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(date);
            calendar2.setTime(date2);
            return calendar.before(calendar2);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage());
        }
    }
}

