/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.condition;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class DateTimeDifference
implements Condition {
    private String date1;
    private String date2;
    private String format = null;
    private boolean lenient = true;
    private int value = 0;
    private String unit = null;

    public void setDatetime1(String string) {
        if (string == null) {
            return;
        }
        if (this.date1 == null) {
            this.date1 = string;
        }
    }

    public void setDatetime2(String string) {
        if (string == null) {
            return;
        }
        if (this.date2 == null) {
            this.date2 = string;
        }
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setUnit(String string) {
        if (string == null) {
            return;
        }
        this.unit = string;
    }

    public boolean eval() throws BuildException {
        try {
            if (this.format == null) {
                throw new BuildException("format is required");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
            simpleDateFormat.setLenient(this.lenient);
            if (this.date1 == null || this.date2 == null) {
                throw new BuildException("Both datetime1 and datetime2 must be set.");
            }
            Date date = simpleDateFormat.parse(this.date1);
            Date date2 = simpleDateFormat.parse(this.date2);
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(date);
            calendar2.setTime(date2);
            Calendar calendar3 = calendar.before(calendar2) ? calendar : calendar2;
            Calendar calendar4 = calendar.before(calendar2) ? calendar2 : calendar;
            int n = 5;
            if (this.unit.equals("second")) {
                n = 13;
            } else if (this.unit.equals("millisecond")) {
                n = 14;
            } else if (this.unit.equals("minute")) {
                n = 12;
            } else if (this.unit.equals("hour")) {
                n = 10;
            } else if (this.unit.equals("day")) {
                n = 5;
            } else if (this.unit.equals("week")) {
                n = 3;
            } else if (this.unit.equals("month")) {
                n = 2;
            } else if (this.unit.equals("year")) {
                n = 1;
            } else {
                throw new BuildException("Unknown unit: " + this.unit);
            }
            int n2 = 0;
            while (calendar3.before(calendar4)) {
                calendar3.add(n, 1);
                ++n2;
            }
            return n2 == this.value;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException(exception.getMessage());
        }
    }
}

