/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.typedefs;

import java.util.Calendar;
import java.util.Hashtable;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class TimeUnit
extends EnumeratedAttribute {
    public static final String MILLISECOND = "millisecond";
    public static final String SECOND = "second";
    public static final String MINUTE = "minute";
    public static final String HOUR = "hour";
    public static final String DAY = "day";
    public static final String WEEK = "week";
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    public static final TimeUnit MILLISECOND_UNIT = new TimeUnit("millisecond");
    public static final TimeUnit SECOND_UNIT = new TimeUnit("second");
    public static final TimeUnit MINUTE_UNIT = new TimeUnit("minute");
    public static final TimeUnit HOUR_UNIT = new TimeUnit("hour");
    public static final TimeUnit DAY_UNIT = new TimeUnit("day");
    public static final TimeUnit WEEK_UNIT = new TimeUnit("week");
    private static final String[] units = new String[]{"millisecond", "second", "minute", "hour", "day", "week", "month", "year"};
    private Hashtable timeTable = new Hashtable();

    public TimeUnit() {
        this.timeTable.put(MILLISECOND, new Long(1L));
        this.timeTable.put(SECOND, new Long(1000L));
        this.timeTable.put(MINUTE, new Long(60000L));
        this.timeTable.put(HOUR, new Long(3600000L));
        this.timeTable.put(DAY, new Long(86400000L));
        this.timeTable.put(WEEK, new Long(604800000L));
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, 1);
        this.timeTable.put(MONTH, new Long(calendar2.getTimeInMillis() - l));
        calendar2.add(2, -1);
        calendar2.add(1, 1);
        this.timeTable.put(YEAR, new Long(calendar2.getTimeInMillis() - l));
    }

    private TimeUnit(String string) {
        this();
        this.setValueProgrammatically(string);
    }

    protected void setValueProgrammatically(String string) {
        this.value = string;
    }

    public long getMultiplier() {
        String string = this.getValue().toLowerCase();
        Long l = (Long)this.timeTable.get(string);
        return l;
    }

    public String[] getValues() {
        return units;
    }

    public long toMillis(long l) {
        return l * this.getMultiplier();
    }
}

