/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class Log {
    private static File outfile = new File(System.getProperty("user.home"), "antelope_debug.log");
    private static final String LS = System.getProperty("line.separator");
    private static boolean canLog = true;

    public static void log(CharSequence charSequence) {
        Log.log(null, charSequence);
    }

    public static void log(Object object, CharSequence charSequence) {
        if (!canLog) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(outfile, true);
            if (object != null) {
                fileWriter.write(new Date().toString() + ": " + object.getClass().getName() + ": ");
            }
            fileWriter.write(((Object)charSequence).toString());
            fileWriter.write(LS);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void log(Throwable throwable) {
        Log.log(null, throwable);
    }

    public static void log(Object object, Throwable throwable) {
        if (!canLog) {
            return;
        }
        Log.log(object, Log.getStackTrace(throwable));
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static {
        System.out.println("Antelope debug log: " + outfile.getAbsolutePath());
    }
}

