/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

public class StopWatch {
    private String name = "";
    private long startTime = 0L;
    private long stopTime = 0L;
    private long totalTime = 0L;
    private boolean running = false;

    public StopWatch() {
        this("");
    }

    public StopWatch(String string) {
        this.name = string;
        this.start();
    }

    public long start() {
        if (!this.running) {
            this.startTime = System.currentTimeMillis();
        }
        this.running = true;
        return this.startTime;
    }

    public long stop() {
        this.stopTime = System.currentTimeMillis();
        if (this.running) {
            this.totalTime += this.stopTime - this.startTime;
        }
        this.running = false;
        return this.stopTime;
    }

    public long total() {
        this.stop();
        return this.totalTime;
    }

    public long elapsed() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getName() {
        return this.name;
    }

    public String format(long l) {
        String string = String.valueOf(l);
        String string2 = "000";
        int n = 3 - string.length();
        if (n >= 0) {
            string = "0." + string2.substring(0, n) + string;
        } else {
            String string3 = string.substring(string.length() - 3);
            string = "";
            int n2 = 0;
            int n3 = 0;
            n2 = (int)(l / 60000L);
            int n4 = n3 = n2 > 0 ? (int)((l - (long)(n2 * 60000)) / 1000L) : (int)(l / 1000L);
            string = n2 > 0 ? String.valueOf(n2) + ":" + (n3 < 10 ? "0" : "") + String.valueOf(n3) + "." + string3 : String.valueOf(n3) + "." + string3;
        }
        return string + " sec";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.name != null) {
            stringBuffer.append(this.name).append(": ");
        }
        stringBuffer.append(this.format(this.totalTime));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StopWatch stopWatch = new StopWatch("test");
        System.out.println(stopWatch.format(1L));
        System.out.println(stopWatch.format(10L));
        System.out.println(stopWatch.format(100L));
        System.out.println(stopWatch.format(1000L));
        System.out.println(stopWatch.format(100000L));
        System.out.println(stopWatch.format(1000000L));
        try {
            System.out.println("StopWatch: " + stopWatch.getName());
            Thread.currentThread();
            Thread.sleep(2000L);
            stopWatch.stop();
            System.out.println(stopWatch.toString());
            stopWatch.start();
            Thread.currentThread();
            Thread.sleep(2000L);
            stopWatch.stop();
            System.out.println("elapsed: " + stopWatch.format(stopWatch.elapsed()));
            System.out.println("total: " + stopWatch.format(stopWatch.total()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

