/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.counter.service.persistence;

import com.liferay.counter.model.Counter;
import com.liferay.counter.model.CounterHolder;
import com.liferay.counter.model.CounterRegister;
import com.liferay.counter.service.persistence.CounterPersistence;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.model.Dummy;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterPersistenceImpl
extends BasePersistenceImpl<Dummy>
implements CounterPersistence {
    private static final int _DEFAULT_CURRENT_ID = 0;
    private static final int _MINIMUM_INCREMENT_SIZE = 1;
    private static final String _NAME = Counter.class.getName();
    private static final String _SQL_DELETE_BY_NAME = "delete from Counter where name = ?";
    private static final String _SQL_INSERT = "insert into Counter(name, currentId) values (?, ?)";
    private static final String _SQL_SELECT_ID_BY_NAME = "select currentId from Counter where name = ?";
    private static final String _SQL_SELECT_NAMES = "select name from Counter order by name asc";
    private static final String _SQL_UPDATE_ID_BY_NAME = "update Counter set currentId = ? where name = ?";
    private static final String _SQL_UPDATE_NAME_BY_NAME = "update Counter set name = ? where name = ?";
    private static final Map<String, CounterRegister> _registerLookup = new ConcurrentHashMap<String, CounterRegister>();

    @Override
    public List<String> getNames() throws SystemException {
        ArrayList<String> arrayList;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(_SQL_SELECT_NAMES);
            rs = ps.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            arrayList = list;
        }
        catch (SQLException sqle) {
            try {
                throw this.processException(sqle);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)connection, ps, rs);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)connection, (Statement)ps, (ResultSet)rs);
        return arrayList;
    }

    @Override
    public long increment() throws SystemException {
        return this.increment(_NAME);
    }

    @Override
    public long increment(String name) throws SystemException {
        return this.increment(name, 1);
    }

    @Override
    public long increment(String name, int size) throws SystemException {
        if (size < 1) {
            size = 1;
        }
        CounterRegister register = this.getCounterRegister(name);
        return this.competeIncrement(register, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void rename(String oldName, String newName) throws SystemException {
        CounterRegister register;
        CounterRegister counterRegister = register = this.getCounterRegister(oldName);
        synchronized (counterRegister) {
            if (_registerLookup.containsKey(newName)) {
                throw new SystemException("Cannot rename " + oldName + " to " + newName);
            }
            Connection connection = null;
            PreparedStatement ps = null;
            try {
                connection = this.getConnection();
                ps = connection.prepareStatement(_SQL_UPDATE_NAME_BY_NAME);
                ps.setString(1, newName);
                ps.setString(2, oldName);
                ps.executeUpdate();
            }
            catch (ObjectNotFoundException onfe) {
                DataAccess.cleanUp((Connection)connection, ps);
            }
            catch (Exception e) {
                throw this.processException(e);
                {
                    catch (Throwable throwable) {
                        DataAccess.cleanUp((Connection)connection, ps);
                        throw throwable;
                    }
                }
            }
            DataAccess.cleanUp((Connection)connection, (Statement)ps);
            register.setName(newName);
            _registerLookup.put(newName, register);
            _registerLookup.remove(oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void reset(String name) throws SystemException {
        CounterRegister register;
        CounterRegister counterRegister = register = this.getCounterRegister(name);
        synchronized (counterRegister) {
            Connection connection = null;
            PreparedStatement ps = null;
            try {
                connection = this.getConnection();
                ps = connection.prepareStatement(_SQL_DELETE_BY_NAME);
                ps.setString(1, name);
                ps.executeUpdate();
            }
            catch (ObjectNotFoundException onfe) {
                DataAccess.cleanUp((Connection)connection, ps);
            }
            catch (Exception e) {
                throw this.processException(e);
                {
                    catch (Throwable throwable) {
                        DataAccess.cleanUp((Connection)connection, ps);
                        throw throwable;
                    }
                }
            }
            DataAccess.cleanUp((Connection)connection, (Statement)ps);
            _registerLookup.remove(name);
        }
    }

    @Override
    public void reset(String name, long size) throws SystemException {
        CounterRegister register = this.createCounterRegister(name, size);
        _registerLookup.put(name, register);
    }

    protected CounterRegister createCounterRegister(String name) throws SystemException {
        return this.createCounterRegister(name, -1L);
    }

    protected CounterRegister createCounterRegister(String name, long size) throws SystemException {
        long rangeMin = -1L;
        long rangeMax = -1L;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(_SQL_SELECT_ID_BY_NAME);
            ps.setString(1, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                rangeMin = rs.getLong(1);
                rangeMax = rangeMin + (long)PropsValues.COUNTER_INCREMENT;
                rs.close();
                ps.close();
                ps = connection.prepareStatement(_SQL_UPDATE_ID_BY_NAME);
                ps.setLong(1, rangeMax);
                ps.setString(2, name);
            } else {
                rangeMin = 0L;
                rangeMax = rangeMin + (long)PropsValues.COUNTER_INCREMENT;
                rs.close();
                ps.close();
                ps = connection.prepareStatement(_SQL_INSERT);
                ps.setString(1, name);
                ps.setLong(2, rangeMax);
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)connection, ps, rs);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)connection, (Statement)ps, (ResultSet)rs);
        if (size > rangeMin) {
            rangeMin = size;
        }
        CounterRegister register = new CounterRegister(name, rangeMin, rangeMax, PropsValues.COUNTER_INCREMENT);
        return register;
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = this.getDataSource().getConnection();
        connection.setAutoCommit(true);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CounterRegister getCounterRegister(String name) throws SystemException {
        CounterRegister register = _registerLookup.get(name);
        if (register != null) {
            return register;
        }
        Map<String, CounterRegister> map = _registerLookup;
        synchronized (map) {
            register = _registerLookup.get(name);
            if (register == null) {
                register = this.createCounterRegister(name);
                _registerLookup.put(name, register);
            }
            return register;
        }
    }

    private long competeIncrement(CounterRegister register, int size) throws SystemException {
        CounterHolder holder = register.getCounterHolder();
        long newValue = holder.addAndGet(size);
        if (newValue <= holder.getRangeMax()) {
            return newValue;
        }
        CompeteLatch latch = register.getCompeteLatch();
        if (!latch.compete()) {
            latch.await();
            return this.competeIncrement(register, size);
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            holder = register.getCounterHolder();
            newValue = holder.addAndGet(size);
            if (newValue > holder.getRangeMax()) {
                connection = this.getConnection();
                ps = connection.prepareStatement(_SQL_SELECT_ID_BY_NAME);
                ps.setString(1, register.getName());
                rs = ps.executeQuery();
                rs.next();
                long currentId = rs.getLong(1);
                newValue = currentId + 1L;
                long rangeMax = currentId + (long)register.getRangeSize();
                rs.close();
                ps.close();
                ps = connection.prepareStatement(_SQL_UPDATE_ID_BY_NAME);
                ps.setLong(1, rangeMax);
                ps.setString(2, register.getName());
                ps.executeUpdate();
                register.setCounterHolder(new CounterHolder(newValue, rangeMax));
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(connection, ps, rs);
                latch.done();
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)connection, ps, rs);
        latch.done();
        return newValue;
    }
}

