/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.service.impl;

import com.liferay.documentlibrary.FileNameException;
import com.liferay.documentlibrary.FileSizeException;
import com.liferay.documentlibrary.SourceFileNameException;
import com.liferay.documentlibrary.service.DLLocalService;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalService;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFolderService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class DLLocalServiceImpl
implements DLLocalService {
    @BeanReference(name="com.liferay.portal.service.GroupLocalService")
    protected GroupLocalService groupLocalService;
    @BeanReference(name="com.liferay.portlet.documentlibrary.service.DLFolderService")
    protected DLFolderService dlFolderService;
    @BeanReference(name="com.liferay.documentlibrary.util.HookProxyBean")
    protected Hook hook;

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, InputStream is) throws PortalException, SystemException {
        this.validate(fileName, is);
        this.hook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries, is);
    }

    public void checkRoot(long companyId) throws SystemException {
        this.hook.checkRoot(companyId);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hook.getFileAsStream(companyId, repositoryId, fileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        return this.hook.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        return this.hook.hasFile(companyId, repositoryId, fileName, versionNumber);
    }

    public void move(String srcDir, String destDir) throws SystemException {
        this.hook.move(srcDir, destDir);
    }

    public Hits search(long companyId, String portletId, long groupId, long userId, long[] repositoryIds, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", portletId);
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (repositoryIds != null && repositoryIds.length > 0) {
                BooleanQuery repositoryIdsQuery = BooleanQueryFactoryUtil.create();
                for (long repositoryId : repositoryIds) {
                    try {
                        if (userId > 0L) {
                            try {
                                this.dlFolderService.getFolder(repositoryId);
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        TermQuery termQuery = TermQueryFactoryUtil.create((String)"repositoryId", (long)repositoryId);
                        repositoryIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                contextQuery.add((Query)repositoryIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("content", keywords);
                searchQuery.addTerm("properties", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long)groupId, (long)userId, (String)DLFileEntry.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, double versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, InputStream is) throws PortalException, SystemException {
        this.validate(fileName, sourceFileName, is);
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries, is);
    }

    public void validate(String fileName, File file) throws PortalException, SystemException {
        this.validate(fileName);
        if (!(!PropsValues.WEBDAV_LITMUS && PrefsPropsUtil.getLong("dl.file.max.size") <= 0L || file != null && file.length() <= PrefsPropsUtil.getLong("dl.file.max.size"))) {
            throw new FileSizeException(fileName);
        }
    }

    public void validate(String fileName, byte[] bytes) throws PortalException, SystemException {
        this.validate(fileName);
        if (!(!PropsValues.WEBDAV_LITMUS && PrefsPropsUtil.getLong("dl.file.max.size") <= 0L || bytes != null && (long)bytes.length <= PrefsPropsUtil.getLong("dl.file.max.size"))) {
            throw new FileSizeException(fileName);
        }
    }

    public void validate(String fileName, InputStream is) throws PortalException, SystemException {
        this.validate(fileName);
        try {
            if (!(!PropsValues.WEBDAV_LITMUS && PrefsPropsUtil.getLong("dl.file.max.size") <= 0L || is != null && (long)is.available() <= PrefsPropsUtil.getLong("dl.file.max.size"))) {
                throw new FileSizeException(fileName);
            }
        }
        catch (IOException ioe) {
            throw new FileSizeException(ioe.getMessage());
        }
    }

    public void validate(String fileName) throws PortalException, SystemException {
        if (fileName.indexOf("\\\\") != -1 || fileName.indexOf("//") != -1 || fileName.indexOf(":") != -1 || fileName.indexOf("*") != -1 || fileName.indexOf("?") != -1 || fileName.indexOf("\"") != -1 || fileName.indexOf("<") != -1 || fileName.indexOf(">") != -1 || fileName.indexOf("|") != -1 || fileName.indexOf("&") != -1 || fileName.indexOf("[") != -1 || fileName.indexOf("]") != -1 || fileName.indexOf("'") != -1) {
            throw new FileNameException(fileName);
        }
        boolean validFileExtension = false;
        String[] fileExtensions = PrefsPropsUtil.getStringArray("dl.file.extensions", ",");
        if (!PropsValues.WEBDAV_LITMUS) {
            for (int i = 0; i < fileExtensions.length; ++i) {
                if (!"*".equals(fileExtensions[i]) && !StringUtil.endsWith((String)fileName, (String)fileExtensions[i])) continue;
                validFileExtension = true;
                break;
            }
            if (!validFileExtension) {
                throw new FileNameException(fileName);
            }
        }
    }

    public void validate(String fileName, String sourceFileName, InputStream is) throws PortalException {
        String fileNameExtension = FileUtil.getExtension((String)fileName);
        String sourceFileNameExtension = FileUtil.getExtension((String)sourceFileName);
        if (!(PropsValues.WEBDAV_LITMUS || !Validator.isNull((String)fileNameExtension) && fileNameExtension.equalsIgnoreCase(sourceFileNameExtension))) {
            throw new SourceFileNameException(sourceFileName);
        }
        if (is == null) {
            throw new FileSizeException(fileName);
        }
    }
}

