/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.service.impl;

import com.liferay.documentlibrary.DirectoryNameException;
import com.liferay.documentlibrary.service.DLLocalService;
import com.liferay.documentlibrary.service.DLService;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.documentlibrary.util.Indexer;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.search.SearchException;
import java.io.File;
import java.util.Date;

public class DLServiceImpl
implements DLService {
    public static final String GROUP_NAME = DLServiceImpl.class.getName();
    public static final String[] GROUP_NAME_ARRAY = new String[]{GROUP_NAME};
    public static final String VERSION = "_VERSION_";
    @BeanReference(name="com.liferay.documentlibrary.service.DLLocalService")
    protected DLLocalService dlLocalService;
    @BeanReference(name="com.liferay.documentlibrary.util.HookProxyBean")
    protected Hook hook;

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        if (dirName == null || dirName.equals("/") || dirName.indexOf("\\\\") != -1 || dirName.indexOf("//") != -1 || dirName.indexOf(":") != -1 || dirName.indexOf("*") != -1 || dirName.indexOf("?") != -1 || dirName.indexOf("\"") != -1 || dirName.indexOf("<") != -1 || dirName.indexOf(">") != -1 || dirName.indexOf("|") != -1 || dirName.indexOf("&") != -1 || dirName.indexOf("[") != -1 || dirName.indexOf("]") != -1 || dirName.indexOf("'") != -1) {
            throw new DirectoryNameException(dirName);
        }
        this.hook.addDirectory(companyId, repositoryId, dirName);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, File file) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, file);
        this.hook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries, file);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, byte[] bytes) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, bytes);
        this.hook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries, bytes);
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException, SystemException {
        this.hook.deleteDirectory(companyId, portletId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException, SystemException {
        this.hook.deleteFile(companyId, portletId, repositoryId, fileName);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        this.hook.deleteFile(companyId, portletId, repositoryId, fileName, versionNumber);
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hook.getFile(companyId, repositoryId, fileName);
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        return this.hook.getFile(companyId, repositoryId, fileName, versionNumber);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        return this.hook.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hook.getFileSize(companyId, repositoryId, fileName);
    }

    public void reIndex(String[] ids) throws SystemException {
        try {
            Indexer indexer = new Indexer();
            indexer.reIndex(ids);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, double versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, File file) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, file);
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries, file);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, double versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, byte[] bytes) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, bytes);
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries, bytes);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws PortalException, SystemException {
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, newRepositoryId, fileName, fileEntryId);
    }
}

