/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.util.FileSystemHook;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;

public class AdvancedFileSystemHook
extends FileSystemHook {
    protected void buildPath(StringBuilder sb, String fileNameFragment) {
        if (fileNameFragment.length() <= 2) {
            return;
        }
        if (this.getDepth(sb.toString()) > 3) {
            return;
        }
        sb.append(fileNameFragment.substring(0, 2) + "/");
        this.buildPath(sb, fileNameFragment.substring(2));
    }

    protected int getDepth(String path) {
        String[] fragments = StringUtil.split((String)path, (String)"/");
        return fragments.length;
    }

    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        return new File(repositoryDir + "/" + dirName);
    }

    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        String ext = "." + FileUtil.getExtension((String)fileName);
        StringBuilder sb = new StringBuilder();
        String fileNameFragment = this.removeExtension(fileName);
        if (fileNameFragment.startsWith("DLFE-")) {
            fileNameFragment = fileNameFragment.substring(5);
            sb.append("DLFE/");
        }
        this.buildPath(sb, fileNameFragment);
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        File fileNameDir = new File(repositoryDir + "/" + sb.toString() + "/" + fileNameFragment + ext);
        return fileNameDir;
    }

    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, double version) {
        String ext = "." + FileUtil.getExtension((String)fileName);
        int pos = fileName.lastIndexOf("/");
        if (pos == -1) {
            StringBuilder sb = new StringBuilder();
            String fileNameFragment = this.removeExtension(fileName);
            if (fileNameFragment.startsWith("DLFE-")) {
                fileNameFragment = fileNameFragment.substring(5);
                sb.append("DLFE/");
            }
            this.buildPath(sb, fileNameFragment);
            File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
            return new File(repositoryDir + "/" + sb.toString() + "/" + fileNameFragment + ext + "/" + fileNameFragment + "_" + version + ext);
        }
        File fileNameDir = this.getDirNameDir(companyId, repositoryId, fileName);
        String fileNameFragment = this.removeExtension(fileName.substring(pos + 1));
        return new File(fileNameDir + "/" + fileNameFragment + "_" + version + ext);
    }

    protected double getHeadVersionNumber(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return 1.0;
        }
        String[] versionNumbers = FileUtil.listFiles((File)fileNameDir);
        double headVersionNumber = 1.0;
        for (int i = 0; i < versionNumbers.length; ++i) {
            double versionNumber;
            String versionNumberFragment = versionNumbers[i];
            int pos = (versionNumberFragment = this.removeExtension(versionNumberFragment)).lastIndexOf("_");
            if (pos > -1) {
                versionNumberFragment = versionNumberFragment.substring(pos + 1);
            }
            if (!((versionNumber = GetterUtil.getDouble((String)versionNumberFragment)) > headVersionNumber)) continue;
            headVersionNumber = versionNumber;
        }
        return headVersionNumber;
    }

    protected String removeExtension(String fileName) {
        String ext = FileUtil.getExtension((String)fileName);
        if (ext != null) {
            fileName = fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }
}

