/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.util.DLIndexer;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.documentlibrary.util.HookFactory;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class DLIndexerImpl
implements DLIndexer {
    private static Log _log = LogFactoryUtil.getLog(DLIndexerImpl.class);

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName) throws SearchException {
        Document doc = this.getFileDocument(companyId, portletId, groupId, repositoryId, fileName);
        if (doc != null) {
            SearchEngineUtil.addDocument((long)companyId, (Document)doc);
        }
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries) throws SearchException {
        Document doc = this.getFileDocument(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries);
        if (doc != null) {
            SearchEngineUtil.addDocument((long)companyId, (Document)doc);
        }
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)this.getFileUID(portletId, repositoryId, fileName));
    }

    public Document getFileDocument(long companyId, String portletId, long groupId, long repositoryId, String fileName) throws SearchException {
        try {
            DLFileEntry fileEntry = null;
            try {
                fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)repositoryId, (String)fileName);
            }
            catch (NoSuchFileEntryException nsfe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("File " + fileName + " in repository " + repositoryId + " exists in the JCR but does " + "not exist in the database"));
                }
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(fileEntry.getTitle());
            sb.append(" ");
            sb.append(fileEntry.getDescription());
            sb.append(" ");
            Properties extraSettingsProps = fileEntry.getExtraSettingsProperties();
            for (Map.Entry<Object, Object> entry : extraSettingsProps.entrySet()) {
                String value = GetterUtil.getString((String)((String)entry.getValue()));
                sb.append(value);
            }
            String properties = sb.toString();
            String[] tagsCategories = TagsEntryLocalServiceUtil.getEntryNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId(), (boolean)false);
            String[] tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
            return this.getFileDocument(companyId, portletId, groupId, repositoryId, fileName, fileEntry.getFileEntryId(), properties, fileEntry.getModifiedDate(), tagsCategories, tagsEntries);
        }
        catch (PortalException pe) {
            throw new SearchException(pe.getMessage());
        }
        catch (SystemException se) {
            throw new SearchException(se.getMessage());
        }
    }

    public Document getFileDocument(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries) throws SearchException {
        int fileExtPos;
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fileEntryId <= 0L) {
            _log.debug((Object)("Not indexing document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntryId));
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntryId));
        }
        String fileExt = "";
        int fileExtVersionPos = fileName.indexOf("_VERSION_");
        if (fileExtVersionPos != -1) {
            fileExtPos = fileName.lastIndexOf(".", fileExtVersionPos);
            if (fileExtPos != -1) {
                fileExt = fileName.substring(fileExtPos, fileExtVersionPos);
            }
        } else {
            fileExtPos = fileName.lastIndexOf(".");
            if (fileExtPos != -1) {
                fileExt = fileName.substring(fileExtPos, fileName.length());
            }
        }
        InputStream is = null;
        try {
            Hook hook = HookFactory.getInstance();
            is = hook.getFileAsStream(companyId, repositoryId, fileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntryId + " does not have any content"));
            }
            return null;
        }
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(portletId, repositoryId, fileName);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", portletId);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        try {
            doc.addFile("content", is, fileExt);
        }
        catch (IOException ioe) {
            throw new SearchException("Cannot extract text from file" + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName);
        }
        doc.addText("properties", properties);
        doc.addKeyword("tagsCategories", tagsCategories);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("repositoryId", repositoryId);
        doc.addKeyword("path", fileName);
        doc.addKeyword("entryClassName", DLFileEntry.class.getName());
        doc.addKeyword("entryClassPK", fileEntryId);
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((String)DLFileEntry.class.getName(), (long)fileEntryId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntryId + " indexed successfully"));
        }
        return doc;
    }

    public String getFileUID(String portletId, long repositoryId, String fileName) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(portletId, repositoryId, fileName);
        return doc.get("uid");
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries) throws SearchException {
        Document doc = this.getFileDocument(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, tagsCategories, tagsEntries);
        if (doc != null) {
            SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
        }
    }
}

