/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.util.BaseHook;
import com.liferay.documentlibrary.util.DLIndexerUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;

public class FileSystemHook
extends BaseHook {
    private static final String _ROOT_DIR = PropsUtil.get("dl.hook.file.system.root.dir");
    private static Log _log = LogFactoryUtil.getLog(FileSystemHook.class);
    private File _rootDir = new File(_ROOT_DIR);

    public FileSystemHook() {
        if (!this._rootDir.exists()) {
            this._rootDir.mkdirs();
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (dirNameDir.exists()) {
            throw new DuplicateDirectoryException(dirNameDir.getPath());
        }
        dirNameDir.mkdirs();
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, InputStream is) throws PortalException, SystemException {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, 1.0);
            if (fileNameVersionFile.exists()) {
                throw new DuplicateFileException(fileNameVersionFile.getPath());
            }
            FileUtil.write((File)fileNameVersionFile, (InputStream)is);
            DLIndexerUtil.addFile((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)fileName, (long)fileEntryId, (String)properties, (Date)modifiedDate, (String[])tagsCategories, (String[])tagsEntries);
        }
        catch (IOException ioe) {
            throw new SystemException();
        }
    }

    public void checkRoot(long companyId) {
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            throw new NoSuchDirectoryException(dirNameDir.getPath());
        }
        FileUtil.deltree((File)dirNameDir);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException, SystemException {
        try {
            File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
            if (!fileNameDir.exists()) {
                throw new NoSuchFileException(fileNameDir.getPath());
            }
            FileUtil.deltree((File)fileNameDir);
            DLIndexerUtil.deleteFile((long)companyId, (String)portletId, (long)repositoryId, (String)fileName);
        }
        catch (SearchException se) {
            throw new SystemException();
        }
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, double versionNumber) throws PortalException {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
        if (!fileNameVersionFile.exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        fileNameVersionFile.delete();
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        try {
            File fileNameVersionFile;
            if (versionNumber == 0.0) {
                versionNumber = this.getHeadVersionNumber(companyId, repositoryId, fileName);
            }
            if (!(fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber)).exists()) {
                throw new NoSuchFileException(fileNameVersionFile.getPath());
            }
            return new FileInputStream(fileNameVersionFile);
        }
        catch (IOException ioe) {
            throw new SystemException();
        }
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            throw new NoSuchDirectoryException(dirNameDir.getPath());
        }
        Object[] fileNames = FileUtil.listDirs((File)dirNameDir);
        Arrays.sort(fileNames);
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = "/" + dirName + "/" + (String)fileNames[i];
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        double versionNumber = this.getHeadVersionNumber(companyId, repositoryId, fileName);
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
        if (!fileNameVersionFile.exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        return fileNameVersionFile.length();
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, double versionNumber) {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
        return fileNameVersionFile.exists();
    }

    public void move(String srcDir, String destDir) {
    }

    public void reIndex(String[] ids) {
        long companyId = GetterUtil.getLong((String)ids[0]);
        String portletId = ids[1];
        long groupId = GetterUtil.getLong((String)ids[2]);
        long repositoryId = GetterUtil.getLong((String)ids[3]);
        File repistoryDir = this.getRepositoryDir(companyId, repositoryId);
        String[] fileNames = FileUtil.listDirs((File)repistoryDir);
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            try {
                Document doc = DLIndexerUtil.getFileDocument((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)fileName);
                SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("Reindexing " + fileName), (Throwable)e);
            }
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws SystemException {
        try {
            File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
            File newFileNameDir = this.getFileNameDir(companyId, newRepositoryId, fileName);
            FileUtil.copyDirectory((File)fileNameDir, (File)newFileNameDir);
            FileUtil.deltree((File)fileNameDir);
            try {
                DLIndexerUtil.deleteFile((long)companyId, (String)portletId, (long)repositoryId, (String)fileName);
            }
            catch (SearchException se) {
                // empty catch block
            }
            DLIndexerUtil.addFile((long)companyId, (String)portletId, (long)groupId, (long)newRepositoryId, (String)fileName);
        }
        catch (SearchException se) {
            throw new SystemException();
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, double versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, InputStream is) throws PortalException, SystemException {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
            if (fileNameVersionFile.exists()) {
                throw new DuplicateFileException(fileNameVersionFile.getPath());
            }
            FileUtil.write((File)fileNameVersionFile, (InputStream)is);
            DLIndexerUtil.updateFile((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)fileName, (long)fileEntryId, (String)properties, (Date)modifiedDate, (String[])tagsCategories, (String[])tagsEntries);
        }
        catch (IOException ioe) {
            throw new SystemException();
        }
    }

    protected File getCompanyDir(long companyId) {
        File companyDir = new File(this._rootDir + "/" + companyId);
        if (!companyDir.exists()) {
            companyDir.mkdirs();
        }
        return companyDir;
    }

    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        return this.getFileNameDir(companyId, repositoryId, dirName);
    }

    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        File fileNameDir = new File(repositoryDir + "/" + fileName);
        return fileNameDir;
    }

    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, double version) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File fileNameVersionFile = new File(fileNameDir + "/" + version);
        return fileNameVersionFile;
    }

    protected double getHeadVersionNumber(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return 1.0;
        }
        String[] versionNumbers = FileUtil.listFiles((File)fileNameDir);
        double headVersionNumber = 1.0;
        for (int i = 0; i < versionNumbers.length; ++i) {
            double versionNumber = GetterUtil.getDouble((String)versionNumbers[i]);
            if (!(versionNumber > headVersionNumber)) continue;
            headVersionNumber = versionNumber;
        }
        return headVersionNumber;
    }

    protected File getRepositoryDir(long companyId, long repositoryId) {
        File companyDir = this.getCompanyDir(companyId);
        File repositoryDir = new File(companyDir + "/" + repositoryId);
        if (!repositoryDir.exists()) {
            repositoryDir.mkdirs();
        }
        return repositoryDir;
    }
}

