/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.util.BaseHook;
import com.liferay.documentlibrary.util.DLIndexerUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.jcr.JCRFactory;
import com.liferay.portal.jcr.JCRFactoryUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.commons.lang.StringUtils;

public class JCRHook
extends BaseHook {
    private static Log _log = LogFactoryUtil.getLog(JCRHook.class);

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (repositoryNode.hasNode(dirName)) {
                throw new DuplicateDirectoryException(dirName);
            }
            String[] dirNameArray = StringUtil.split((String)dirName, (String)"/");
            Node dirNode = repositoryNode;
            for (int i = 0; i < dirNameArray.length; ++i) {
                if (!Validator.isNotNull((String)dirNameArray[i])) continue;
                dirNode = dirNode.hasNode(dirNameArray[i]) ? dirNode.getNode(dirNameArray[i]) : dirNode.addNode(dirNameArray[i], "nt:folder");
            }
            session.save();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, InputStream is) throws PortalException, SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (repositoryNode.hasNode(fileName)) {
                throw new DuplicateFileException(fileName);
            }
            Node fileNode = repositoryNode.addNode(fileName, "nt:file");
            Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
            contentNode.addMixin("mix:versionable");
            contentNode.setProperty("jcr:mimeType", "text/plain");
            contentNode.setProperty("jcr:data", is);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            session.save();
            Version version = contentNode.checkin();
            contentNode.getVersionHistory().addVersionLabel(version.getName(), String.valueOf(1.0), false);
            DLIndexerUtil.addFile((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)fileName, (long)fileEntryId, (String)properties, (Date)modifiedDate, (String[])tagsCategories, (String[])tagsEntries);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void checkRoot(long companyId) throws SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            this.getRootNode(session, companyId);
            session.save();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException, SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node dirNode = repositoryNode.getNode(dirName);
            this.deleteDirectory(companyId, portletId, repositoryId, dirNode);
            dirNode.remove();
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchDirectoryException(dirName);
        }
        catch (RepositoryException e) {
            throw new PortalException((Throwable)e);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException, SystemException {
        Node contentNode;
        Node fileNode;
        Node repositoryNode;
        Node rootNode;
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            rootNode = this.getRootNode(session, companyId);
            repositoryNode = this.getFolderNode(rootNode, repositoryId);
            fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            contentNode.checkout();
            contentNode.setProperty("jcr:mimeType", "text/plain");
            contentNode.setProperty("jcr:data", "");
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            session.save();
            Version version = contentNode.checkin();
            contentNode.getVersionHistory().addVersionLabel(version.getName(), "0.0", false);
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        try {
            session = JCRFactoryUtil.createSession();
            rootNode = this.getRootNode(session, companyId);
            repositoryNode = this.getFolderNode(rootNode, repositoryId);
            fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            VersionHistory versionHistory = contentNode.getVersionHistory();
            VersionIterator itr = versionHistory.getAllVersions();
            while (itr.hasNext()) {
                Version version = itr.nextVersion();
                if (itr.getPosition() == itr.getSize()) break;
                if (StringUtils.equals((String)"jcr:rootVersion", (String)version.getName())) continue;
                versionHistory.removeVersion(version.getName());
            }
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        try {
            session = JCRFactoryUtil.createSession();
            rootNode = this.getRootNode(session, companyId);
            repositoryNode = this.getFolderNode(rootNode, repositoryId);
            fileNode = repositoryNode.getNode(fileName);
            DLIndexerUtil.deleteFile((long)companyId, (String)portletId, (long)repositoryId, (String)fileName);
            fileNode.remove();
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        String versionLabel = String.valueOf(versionNumber);
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            VersionHistory versionHistory = contentNode.getVersionHistory();
            Version version = versionHistory.getVersionByLabel(versionLabel);
            versionHistory.removeVersion(version.getName());
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        UnsyncBufferedInputStream is = null;
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, versionNumber);
            Property data = contentNode.getProperty("jcr:data");
            is = new UnsyncBufferedInputStream(data.getStream());
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return is;
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        ArrayList<String> fileNames = new ArrayList<String>();
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node dirNode = repositoryNode.getNode(dirName);
            NodeIterator itr = dirNode.getNodes();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if (!node.getPrimaryNodeType().getName().equals("nt:file")) continue;
                fileNames.add(dirName + "/" + node.getName());
            }
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchDirectoryException(dirName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        long size;
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, 0.0);
            size = contentNode.getProperty("jcr:data").getLength();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return size;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        try {
            this.getFileContentNode(companyId, repositoryId, fileName, versionNumber);
        }
        catch (NoSuchFileException nsfe) {
            return false;
        }
        return true;
    }

    public void move(String srcDir, String destDir) throws SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            session.move(srcDir, destDir);
            session.save();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        long companyId = GetterUtil.getLong((String)ids[0]);
        String portletId = ids[1];
        long groupId = GetterUtil.getLong((String)ids[2]);
        long repositoryId = GetterUtil.getLong((String)ids[3]);
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            NodeIterator itr = repositoryNode.getNodes();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if (!node.getPrimaryNodeType().getName().equals("nt:file")) continue;
                try {
                    Document doc = DLIndexerUtil.getFileDocument((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)node.getName());
                    SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
                }
                catch (Exception e2) {
                    _log.error((Object)("Reindexing " + node.getName()), (Throwable)e2);
                }
            }
        }
        catch (Exception e1) {
            throw new SearchException((Throwable)e1);
        }
        finally {
            try {
                if (session != null) {
                    session.logout();
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws PortalException, SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            Node newRepositoryNode = this.getFolderNode(rootNode, newRepositoryId);
            if (newRepositoryNode.hasNode(fileName)) {
                throw new DuplicateFileException(fileName);
            }
            Node newFileNode = newRepositoryNode.addNode(fileName, "nt:file");
            Node newContentNode = newFileNode.addNode("jcr:content", "nt:resource");
            VersionHistory versionHistory = contentNode.getVersionHistory();
            String[] versionLabels = versionHistory.getVersionLabels();
            for (int i = versionLabels.length - 1; i >= 0; --i) {
                Version version = versionHistory.getVersionByLabel(versionLabels[i]);
                Node frozenContentNode = version.getNode("jcr:frozenNode");
                if (i == versionLabels.length - 1) {
                    newContentNode.addMixin("mix:versionable");
                } else {
                    newContentNode.checkout();
                }
                newContentNode.setProperty("jcr:mimeType", "text/plain");
                newContentNode.setProperty("jcr:data", frozenContentNode.getProperty("jcr:data").getStream());
                newContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
                Version newVersion = newContentNode.checkin();
                newContentNode.getVersionHistory().addVersionLabel(newVersion.getName(), versionLabels[i], false);
            }
            fileNode.remove();
            session.save();
            try {
                DLIndexerUtil.deleteFile((long)companyId, (String)portletId, (long)repositoryId, (String)fileName);
            }
            catch (SearchException se) {
                // empty catch block
            }
            DLIndexerUtil.addFile((long)companyId, (String)portletId, (long)groupId, (long)newRepositoryId, (String)fileName);
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, double versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, InputStream is) throws PortalException, SystemException {
        String versionLabel = String.valueOf(versionNumber);
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            contentNode.checkout();
            contentNode.setProperty("jcr:mimeType", "text/plain");
            contentNode.setProperty("jcr:data", is);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            session.save();
            Version version = contentNode.checkin();
            contentNode.getVersionHistory().addVersionLabel(version.getName(), versionLabel, false);
            DLIndexerUtil.updateFile((long)companyId, (String)portletId, (long)groupId, (long)repositoryId, (String)fileName, (long)fileEntryId, (String)properties, (Date)modifiedDate, (String[])tagsCategories, (String[])tagsEntries);
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void deleteDirectory(long companyId, String portletId, long repositoryId, Node dirNode) throws SearchException {
        try {
            NodeIterator itr = dirNode.getNodes();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                String primaryNodeTypeName = node.getPrimaryNodeType().getName();
                if (primaryNodeTypeName.equals("nt:folder")) {
                    this.deleteDirectory(companyId, portletId, repositoryId, node);
                    continue;
                }
                if (!primaryNodeTypeName.equals("nt:file")) continue;
                DLIndexerUtil.deleteFile((long)companyId, (String)portletId, (long)repositoryId, (String)node.getName());
            }
            DLIndexerUtil.deleteFile((long)companyId, (String)portletId, (long)repositoryId, (String)dirNode.getName());
        }
        catch (RepositoryException e) {
            _log.error((Throwable)e);
        }
    }

    protected Node getFileContentNode(long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        Node contentNode = null;
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, versionNumber);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return contentNode;
    }

    protected Node getFileContentNode(Session session, long companyId, long repositoryId, String fileName, double versionNumber) throws PortalException, SystemException {
        String versionLabel = String.valueOf(versionNumber);
        Node contentNode = null;
        try {
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            if (versionNumber > 0.0) {
                VersionHistory versionHistory = contentNode.getVersionHistory();
                Version version = versionHistory.getVersionByLabel(versionLabel);
                contentNode = version.getNode("jcr:frozenNode");
            }
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(fileName);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        return contentNode;
    }

    protected Node getFolderNode(Node node, long name) throws RepositoryException {
        return this.getFolderNode(node, String.valueOf(name));
    }

    protected Node getFolderNode(Node node, String name) throws RepositoryException {
        Node folderNode = null;
        folderNode = node.hasNode(name) ? node.getNode(name) : node.addNode(name, "nt:folder");
        return folderNode;
    }

    protected Node getRootNode(Session session, long companyId) throws RepositoryException {
        Node companyNode = this.getFolderNode(session.getRootNode(), companyId);
        return this.getFolderNode(companyNode, JCRFactory.NODE_DOCUMENTLIBRARY);
    }
}

