/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.messaging;

import com.liferay.mail.util.HookFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.mail.MailEngine;
import java.util.ArrayList;
import javax.mail.internet.InternetAddress;

public class MailMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MailMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doMailMessage(MailMessage mailMessage) throws Exception {
        InternetAddress from;
        Object[] auditTrail = InternetAddress.parse((String)PropsValues.MAIL_AUDIT_TRAIL);
        if (auditTrail.length > 0) {
            Object[] bcc = mailMessage.getBCC();
            if (bcc != null) {
                Object[] allBCC = new InternetAddress[bcc.length + auditTrail.length];
                ArrayUtil.combine((Object[])bcc, (Object[])auditTrail, (Object[])allBCC);
                mailMessage.setBCC((InternetAddress[])allBCC);
            } else {
                mailMessage.setBCC((InternetAddress[])auditTrail);
            }
        }
        if ((from = this.filterInternetAddress(mailMessage.getFrom())) == null) {
            return;
        }
        mailMessage.setFrom(from);
        InternetAddress[] to = this.filterInternetAddresses(mailMessage.getTo());
        mailMessage.setTo(to);
        InternetAddress[] cc = this.filterInternetAddresses(mailMessage.getCC());
        mailMessage.setCC(cc);
        InternetAddress[] bcc = this.filterInternetAddresses(mailMessage.getBCC());
        mailMessage.setBCC(bcc);
        InternetAddress[] bulkAddresses = this.filterInternetAddresses(mailMessage.getBulkAddresses());
        mailMessage.setBulkAddresses(bulkAddresses);
        if (to != null && to.length > 0 || cc != null && cc.length > 0 || bcc != null && bcc.length > 0 || bulkAddresses != null && bulkAddresses.length > 0) {
            MailEngine.send((MailMessage)mailMessage);
        }
    }

    protected void doMethodWrapper(MethodWrapper methodWrapper) throws Exception {
        MethodInvoker.invoke((MethodWrapper)methodWrapper, (Object)HookFactory.getInstance());
    }

    protected void doReceive(Message message) throws Exception {
        Object payload = message.getPayload();
        if (payload instanceof MailMessage) {
            this.doMailMessage((MailMessage)payload);
        } else if (payload instanceof MethodWrapper) {
            this.doMethodWrapper((MethodWrapper)payload);
        }
    }

    protected InternetAddress filterInternetAddress(InternetAddress internetAddress) {
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(internetAddress.getAddress())) {
            return null;
        }
        return internetAddress;
    }

    protected InternetAddress[] filterInternetAddresses(InternetAddress[] internetAddresses) {
        if (internetAddresses == null) {
            return null;
        }
        ArrayList<InternetAddress> filteredInternetAddresses = new ArrayList<InternetAddress>(internetAddresses.length);
        for (InternetAddress internetAddress : internetAddresses) {
            InternetAddress filteredInternetAddress = this.filterInternetAddress(internetAddress);
            if (filteredInternetAddress == null) continue;
            filteredInternetAddresses.add(filteredInternetAddress);
        }
        return filteredInternetAddresses.toArray(new InternetAddress[filteredInternetAddresses.size()]);
    }
}

