/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.service.impl;

import com.liferay.mail.model.Filter;
import com.liferay.mail.service.MailService;
import com.liferay.mail.util.Hook;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.BooleanWrapper;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServiceImpl
implements MailService {
    private static Log _log = LogFactoryUtil.getLog(MailServiceImpl.class);
    private Session _session;

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"addForward");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "addForward", new Object[]{new LongWrapper(companyId), new LongWrapper(userId), filters, emailAddresses, new BooleanWrapper(leaveCopy)});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"addUser");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "addUser", new Object[]{new LongWrapper(companyId), new LongWrapper(userId), password, firstName, middleName, lastName, emailAddress});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"addVacationMessage");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "addVacationMessage", new Object[]{new LongWrapper(companyId), new LongWrapper(userId), emailAddress, vacationMessage});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public void clearSession() {
        this._session = null;
    }

    public void deleteEmailAddress(long companyId, long userId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"deleteEmailAddress");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "deleteEmailAddress", new Object[]{new LongWrapper(companyId), new LongWrapper(userId)});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public void deleteUser(long companyId, long userId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"deleteUser");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "deleteUser", new Object[]{new LongWrapper(companyId), new LongWrapper(userId)});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public Session getSession() throws SystemException {
        Properties properties;
        block9: {
            if (this._session != null) {
                return this._session;
            }
            Session session = InfrastructureUtil.getMailSession();
            if (!PrefsPropsUtil.getBoolean("mail.session.mail")) {
                this._session = session;
                return this._session;
            }
            String advancedPropertiesString = PrefsPropsUtil.getString("mail.session.mail.advanced.properties", PropsValues.MAIL_SESSION_MAIL_ADVANCED_PROPERTIES);
            String pop3Host = PrefsPropsUtil.getString("mail.session.mail.pop3.host", PropsValues.MAIL_SESSION_MAIL_POP3_HOST);
            String pop3Password = PrefsPropsUtil.getString("mail.session.mail.pop3.password", PropsValues.MAIL_SESSION_MAIL_POP3_PASSWORD);
            int pop3Port = PrefsPropsUtil.getInteger("mail.session.mail.pop3.port", PropsValues.MAIL_SESSION_MAIL_POP3_PORT);
            String pop3User = PrefsPropsUtil.getString("mail.session.mail.pop3.user", PropsValues.MAIL_SESSION_MAIL_POP3_USER);
            String smtpHost = PrefsPropsUtil.getString("mail.session.mail.smtp.host", PropsValues.MAIL_SESSION_MAIL_SMTP_HOST);
            String smtpPassword = PrefsPropsUtil.getString("mail.session.mail.smtp.password", PropsValues.MAIL_SESSION_MAIL_SMTP_PASSWORD);
            int smtpPort = PrefsPropsUtil.getInteger("mail.session.mail.smtp.port", PropsValues.MAIL_SESSION_MAIL_SMTP_PORT);
            String smtpUser = PrefsPropsUtil.getString("mail.session.mail.smtp.user", PropsValues.MAIL_SESSION_MAIL_SMTP_USER);
            String storeProtocol = PrefsPropsUtil.getString("mail.session.mail.store.protocol", PropsValues.MAIL_SESSION_MAIL_STORE_PROTOCOL);
            String transportProtocol = PrefsPropsUtil.getString("mail.session.mail.transport.protocol", PropsValues.MAIL_SESSION_MAIL_TRANSPORT_PROTOCOL);
            properties = session.getProperties();
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            properties.setProperty("mail.store.protocol", storeProtocol);
            String storePrefix = "mail." + storeProtocol + ".";
            properties.setProperty(storePrefix + "host", pop3Host);
            properties.setProperty(storePrefix + "password", pop3Password);
            properties.setProperty(storePrefix + "port", String.valueOf(pop3Port));
            properties.setProperty(storePrefix + "user", pop3User);
            if (!transportProtocol.equals("smtps")) {
                transportProtocol = "smtp";
            }
            properties.setProperty("mail.transport.protocol", transportProtocol);
            String transportPrefix = "mail." + transportProtocol + ".";
            boolean smtpAuth = false;
            if (Validator.isNotNull((String)smtpPassword) || Validator.isNotNull((String)smtpUser)) {
                smtpAuth = true;
            }
            properties.setProperty(transportPrefix + "auth", String.valueOf(smtpAuth));
            properties.setProperty(transportPrefix + "host", smtpHost);
            properties.setProperty(transportPrefix + "password", smtpPassword);
            properties.setProperty(transportPrefix + "port", String.valueOf(smtpPort));
            properties.setProperty(transportPrefix + "user", smtpUser);
            try {
                if (Validator.isNotNull((String)advancedPropertiesString)) {
                    Properties advancedProperties = PropertiesUtil.load((String)advancedPropertiesString);
                    for (Map.Entry<Object, Object> entry : advancedProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        properties.setProperty(key, value);
                    }
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        this._session = Session.getInstance((Properties)properties);
        return this._session;
    }

    public void sendEmail(MailMessage mailMessage) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"sendEmail");
        }
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)mailMessage);
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"updateBlocked");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "updateBlocked", new Object[]{new LongWrapper(companyId), new LongWrapper(userId), blocked});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"updateEmailAddress");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "updateEmailAddress", new Object[]{new LongWrapper(companyId), new LongWrapper(userId), emailAddress});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }

    public void updatePassword(long companyId, long userId, String password) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"updatePassword");
        }
        MethodWrapper methodWrapper = new MethodWrapper(Hook.class.getName(), "updatePassword", new Object[]{new LongWrapper(companyId), new LongWrapper(userId), password});
        MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodWrapper);
    }
}

