/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.model.Filter;
import com.liferay.mail.util.Hook;
import com.liferay.portal.googleapps.GoogleApps;
import com.liferay.portal.googleapps.GoogleAppsFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.ContactConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleHook
implements Hook {
    private static Log _log = LogFactoryUtil.getLog(GoogleHook.class);

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        try {
            String nickname = this._getNickname(emailAddress);
            GoogleApps googleApps = GoogleAppsFactory.getGoogleApps(companyId);
            googleApps.addUser(userId, password, firstName, lastName);
            googleApps.addNickname(userId, nickname);
            googleApps.addSendAs(userId, ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName), emailAddress);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
    }

    public void deleteEmailAddress(long companyId, long userId) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            String nickname = this._getNickname(user.getEmailAddress());
            GoogleApps googleApps = GoogleAppsFactory.getGoogleApps(companyId);
            googleApps.deleteNickname(nickname);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void deleteUser(long companyId, long userId) {
        try {
            GoogleApps googleApps = GoogleAppsFactory.getGoogleApps(companyId);
            googleApps.deleteUser(userId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            this.deleteEmailAddress(companyId, userId);
            GoogleApps googleApps = GoogleAppsFactory.getGoogleApps(companyId);
            googleApps.addNickname(userId, emailAddress);
            googleApps.addSendAs(userId, user.getFullName(), emailAddress);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updatePassword(long companyId, long userId, String password) {
        try {
            GoogleApps googleApps = GoogleAppsFactory.getGoogleApps(companyId);
            googleApps.updatePassword(userId, password);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private String _getNickname(String emailAddress) {
        int pos = emailAddress.indexOf("@");
        return emailAddress.substring(0, pos);
    }
}

