/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portlet.tags.model.TagsAssetDisplay;
import com.liferay.portlet.tags.model.TagsAssetType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONServiceAction
extends JSONAction {
    private static Log _log = LogFactoryUtil.getLog(JSONServiceAction.class);
    private Map<String, Object[]> _methodCache = new HashMap<String, Object[]>();

    public static JSONObject toJSONObject(TagsAssetDisplay assetDisplay) {
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        jsonObj.put("assetId", assetDisplay.getAssetId());
        jsonObj.put("companyId", assetDisplay.getCompanyId());
        jsonObj.put("userId", assetDisplay.getUserId());
        jsonObj.put("userName", assetDisplay.getUserName());
        jsonObj.put("createDate", assetDisplay.getCreateDate());
        jsonObj.put("modifiedDate", assetDisplay.getModifiedDate());
        jsonObj.put("classNameId", assetDisplay.getClassNameId());
        jsonObj.put("className", assetDisplay.getClassName());
        jsonObj.put("classPK", assetDisplay.getClassPK());
        jsonObj.put("portletId", assetDisplay.getPortletId());
        jsonObj.put("portletTitle", assetDisplay.getPortletTitle());
        jsonObj.put("startDate", assetDisplay.getStartDate());
        jsonObj.put("endDate", assetDisplay.getEndDate());
        jsonObj.put("publishDate", assetDisplay.getPublishDate());
        jsonObj.put("expirationDate", assetDisplay.getExpirationDate());
        jsonObj.put("mimeType", assetDisplay.getMimeType());
        jsonObj.put("title", assetDisplay.getTitle());
        jsonObj.put("description", assetDisplay.getDescription());
        jsonObj.put("summary", assetDisplay.getSummary());
        jsonObj.put("url", assetDisplay.getUrl());
        jsonObj.put("height", assetDisplay.getHeight());
        jsonObj.put("width", assetDisplay.getWidth());
        jsonObj.put("priority", assetDisplay.getPriority());
        jsonObj.put("viewCount", assetDisplay.getViewCount());
        jsonObj.put("tagsEntries", assetDisplay.getTagsEntries());
        return jsonObj;
    }

    public static JSONObject toJSONObject(TagsAssetType assetType) {
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        jsonObj.put("classNameId", assetType.getClassNameId());
        jsonObj.put("className", assetType.getClassName());
        jsonObj.put("portletId", assetType.getPortletId());
        jsonObj.put("portletTitle", assetType.getPortletTitle());
        return jsonObj;
    }

    @Override
    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        String methodName = ParamUtil.getString((HttpServletRequest)request, (String)"serviceMethodName");
        String[] serviceParameters = this.getStringArrayFromJSON(request, "serviceParameters");
        String[] serviceParameterTypes = this.getStringArrayFromJSON(request, "serviceParameterTypes");
        if (!this.isValidRequest(request)) {
            return null;
        }
        Class<?> classObj = Class.forName(className);
        Object[] methodAndParameterTypes = this.getMethodAndParameterTypes(classObj, methodName, serviceParameters, serviceParameterTypes);
        if (methodAndParameterTypes != null) {
            Method method = (Method)methodAndParameterTypes[0];
            Class[] parameterTypes = (Class[])methodAndParameterTypes[1];
            Object[] args = new Object[serviceParameters.length];
            for (int i = 0; i < serviceParameters.length; ++i) {
                args[i] = this.getArgValue(request, classObj, methodName, serviceParameters[i], parameterTypes[i]);
            }
            try {
                Object returnObj;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invoking class " + classObj + " on method " + method.getName() + " with args " + args));
                }
                if ((returnObj = method.invoke(classObj, args)) != null) {
                    return this.getReturnValue(returnObj);
                }
                JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
                return jsonObj.toString();
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invoked class " + classObj + " on method " + method.getName() + " with args " + args), (Throwable)e);
                }
                JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
                if (e instanceof InvocationTargetException) {
                    jsonObj.put("exception", e.getCause().toString());
                } else {
                    jsonObj.put("exception", e.getMessage());
                }
                return jsonObj.toString();
            }
        }
        return null;
    }

    protected Object getArgValue(HttpServletRequest request, Class<?> classObj, String methodName, String parameter, Class<?> parameterType) throws Exception {
        String parameterTypeName = parameterType.getName();
        String value = ParamUtil.getString((HttpServletRequest)request, (String)parameter);
        if (Validator.isNull((String)value) && !parameterTypeName.equals("[Ljava.lang.String;")) {
            return null;
        }
        if (parameterTypeName.equals("boolean") || parameterTypeName.equals(Boolean.class.getName())) {
            return ParamUtil.getBoolean((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("double") || parameterTypeName.equals(Double.class.getName())) {
            return new Double(ParamUtil.getDouble((HttpServletRequest)request, (String)parameter));
        }
        if (parameterTypeName.equals("int") || parameterTypeName.equals(Integer.class.getName())) {
            return new Integer(ParamUtil.getInteger((HttpServletRequest)request, (String)parameter));
        }
        if (parameterTypeName.equals("long") || parameterTypeName.equals(Long.class.getName())) {
            return new Long(ParamUtil.getLong((HttpServletRequest)request, (String)parameter));
        }
        if (parameterTypeName.equals("short") || parameterTypeName.equals(Short.class.getName())) {
            return new Short(ParamUtil.getShort((HttpServletRequest)request, (String)parameter));
        }
        if (parameterTypeName.equals(Date.class.getName())) {
            return new Date(ParamUtil.getLong((HttpServletRequest)request, (String)parameter));
        }
        if (parameterTypeName.equals(ServiceContext.class.getName())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            jsonObject.put("javaClass", ServiceContext.class.getName());
            return ServiceContextUtil.deserialize((JSONObject)jsonObject);
        }
        if (parameterTypeName.equals(String.class.getName())) {
            return value;
        }
        if (parameterTypeName.equals("[Z")) {
            return ParamUtil.getBooleanValues((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("[D")) {
            return ParamUtil.getDoubleValues((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("[F")) {
            return ParamUtil.getFloatValues((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("[I")) {
            return ParamUtil.getIntegerValues((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("[J")) {
            return ParamUtil.getLongValues((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("[S")) {
            return ParamUtil.getShortValues((HttpServletRequest)request, (String)parameter);
        }
        if (parameterTypeName.equals("[Ljava.lang.String;")) {
            return StringUtil.split((String)value);
        }
        if (parameterTypeName.equals("[[Z")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                boolean[][] doubleArray = new boolean[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getBoolean((String)curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new boolean[0][0];
        }
        if (parameterTypeName.equals("[[D")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                double[][] doubleArray = new double[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getDouble((String)curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new double[0][0];
        }
        if (parameterTypeName.equals("[[F")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                float[][] doubleArray = new float[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getFloat((String)curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new float[0][0];
        }
        if (parameterTypeName.equals("[[I")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                int[][] doubleArray = new int[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getInteger((String)curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new int[0][0];
        }
        if (parameterTypeName.equals("[[J")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                long[][] doubleArray = new long[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getLong((String)curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new long[0][0];
        }
        if (parameterTypeName.equals("[[S")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                short[][] doubleArray = new short[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    for (int j = 0; j < curValues.length; ++j) {
                        doubleArray[i][j] = GetterUtil.getShort((String)curValues[j]);
                    }
                }
                return doubleArray;
            }
            return new short[0][0];
        }
        if (parameterTypeName.equals("[[Ljava.lang.String")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                String[][] doubleArray = new String[values.length][values0.length];
                for (int i = 0; i < values.length; ++i) {
                    doubleArray[i] = StringUtil.split((String)values[i]);
                }
                return doubleArray;
            }
            return new String[0][0];
        }
        _log.error((Object)("Unsupported parameter type for class " + classObj + ", method " + methodName + ", parameter " + parameter + ", and type " + parameterTypeName));
        return null;
    }

    protected Object[] getMethodAndParameterTypes(Class<?> classObj, String methodName, String[] parameters, String[] parameterTypes) throws Exception {
        String parameterNames = StringUtil.merge((Object[])parameters);
        String key = classObj.getName() + "_METHOD_NAME_" + methodName + "_PARAMETERS_" + parameterNames;
        Object[] methodAndParameterTypes = this._methodCache.get(key);
        if (methodAndParameterTypes != null) {
            return methodAndParameterTypes;
        }
        Method method = null;
        Class<?>[] methodParameterTypes = null;
        Method[] methods = classObj.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] curParameterTypes;
            Method curMethod = methods[i];
            if (!curMethod.getName().equals(methodName) || (curParameterTypes = curMethod.getParameterTypes()).length != parameters.length) continue;
            if (parameterTypes.length > 0 && parameterTypes.length == curParameterTypes.length) {
                boolean match = true;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    String t1 = parameterTypes[j];
                    String t2 = curParameterTypes[j].getName();
                    if (t1.equals(t2)) continue;
                    match = false;
                }
                if (!match) continue;
                method = curMethod;
                methodParameterTypes = curParameterTypes;
                break;
            }
            if (method != null) {
                _log.error((Object)("Obscure method name for class " + classObj + ", method " + methodName + ", and parameters " + parameterNames));
                return null;
            }
            method = curMethod;
            methodParameterTypes = curParameterTypes;
        }
        if (method != null) {
            methodAndParameterTypes = new Object[]{method, methodParameterTypes};
            this._methodCache.put(key, methodAndParameterTypes);
            return methodAndParameterTypes;
        }
        _log.error((Object)("No method found for class " + classObj + ", method " + methodName + ", and parameters " + parameterNames));
        return null;
    }

    protected String getReturnValue(Object returnObj) throws Exception {
        if (returnObj instanceof Boolean || returnObj instanceof Double || returnObj instanceof Integer || returnObj instanceof Long || returnObj instanceof Short || returnObj instanceof String) {
            JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
            jsonObj.put("returnValue", returnObj.toString());
            return jsonObj.toString();
        }
        if (returnObj instanceof BaseModel) {
            String serlializerClassName = this.getSerializerClassName(returnObj);
            MethodWrapper methodWrapper = new MethodWrapper(serlializerClassName, "toJSONObject", returnObj);
            JSONObject jsonObj = (JSONObject)MethodInvoker.invoke((MethodWrapper)methodWrapper, (boolean)false);
            return jsonObj.toString();
        }
        if (returnObj instanceof BaseModel[]) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            BaseModel[] returnArray = (BaseModel[])returnObj;
            if (returnArray.length > 0) {
                BaseModel returnItem0 = returnArray[0];
                String serializerClassName = this.getSerializerClassName(returnItem0);
                MethodWrapper methodWrapper = new MethodWrapper(serializerClassName, "toJSONArray", returnObj);
                jsonArray = (JSONArray)MethodInvoker.invoke((MethodWrapper)methodWrapper, (boolean)false);
            }
            return jsonArray.toString();
        }
        if (returnObj instanceof BaseModel[][]) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            BaseModel[][] returnArray = (BaseModel[][])returnObj;
            if (returnArray.length > 0 && returnArray[0].length > 0) {
                BaseModel returnItem0 = returnArray[0][0];
                String serializerClassName = this.getSerializerClassName(returnItem0);
                MethodWrapper methodWrapper = new MethodWrapper(serializerClassName, "toJSONArray", returnObj);
                jsonArray = (JSONArray)MethodInvoker.invoke((MethodWrapper)methodWrapper, (boolean)false);
            }
            return jsonArray.toString();
        }
        if (returnObj instanceof List) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            List returnList = (List)returnObj;
            if (!returnList.isEmpty()) {
                Object returnItem0 = returnList.get(0);
                String serlializerClassName = this.getSerializerClassName(returnItem0);
                MethodWrapper methodWrapper = new MethodWrapper(serlializerClassName, "toJSONArray", returnObj);
                jsonArray = (JSONArray)MethodInvoker.invoke((MethodWrapper)methodWrapper, (boolean)false);
            }
            return jsonArray.toString();
        }
        if (returnObj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)returnObj;
            return jsonArray.toString();
        }
        if (returnObj instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)returnObj;
            return jsonObj.toString();
        }
        if (returnObj instanceof TagsAssetDisplay) {
            return this.getReturnValue((TagsAssetDisplay)returnObj);
        }
        if (returnObj instanceof TagsAssetDisplay[]) {
            return this.getReturnValue((TagsAssetDisplay[])returnObj);
        }
        if (returnObj instanceof TagsAssetType) {
            return this.getReturnValue((TagsAssetType)returnObj);
        }
        if (returnObj instanceof TagsAssetType[]) {
            return this.getReturnValue((TagsAssetType[])returnObj);
        }
        return JSONFactoryUtil.serialize((Object)returnObj);
    }

    protected String getReturnValue(TagsAssetDisplay assetDisplay) throws Exception {
        JSONObject jsonObj = JSONServiceAction.toJSONObject(assetDisplay);
        return jsonObj.toString();
    }

    protected String getReturnValue(TagsAssetDisplay[] assetDisplays) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (int i = 0; i < assetDisplays.length; ++i) {
            TagsAssetDisplay assetDisplay = assetDisplays[i];
            jsonArray.put(JSONServiceAction.toJSONObject(assetDisplay));
        }
        return jsonArray.toString();
    }

    protected String getReturnValue(TagsAssetType assetType) throws Exception {
        JSONObject jsonObj = JSONServiceAction.toJSONObject(assetType);
        return jsonObj.toString();
    }

    protected String getReturnValue(TagsAssetType[] assetTypes) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (int i = 0; i < assetTypes.length; ++i) {
            TagsAssetType assetType = assetTypes[i];
            jsonArray.put(JSONServiceAction.toJSONObject(assetType));
        }
        return jsonArray.toString();
    }

    protected String getSerializerClassName(Object obj) {
        String serlializerClassName = StringUtil.replace((String)obj.getClass().getName(), (String[])new String[]{".model.impl.", "Impl"}, (String[])new String[]{".service.http.", "JSONSerializer"});
        return serlializerClassName;
    }

    protected String[] getStringArrayFromJSON(HttpServletRequest request, String param) throws JSONException {
        String json = ParamUtil.getString((HttpServletRequest)request, (String)param, (String)"[]");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        return ArrayUtil.toStringArray((JSONArray)jsonArray);
    }

    protected boolean isValidRequest(HttpServletRequest request) {
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil");
    }
}

