/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionRequestFactory;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.ActionResponseFactory;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.EventRequestFactory;
import com.liferay.portlet.EventRequestImpl;
import com.liferay.portlet.EventResponseFactory;
import com.liferay.portlet.EventResponseImpl;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.InvokerPortletImpl;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.ResourceRequestFactory;
import com.liferay.portlet.ResourceResponseFactory;
import com.liferay.portlet.StateAwareResponseImpl;
import com.liferay.portlet.login.util.LoginUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(LayoutAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        Boolean layoutDefault = (Boolean)request.getAttribute("LAYOUT_DEFAULT");
        if (layoutDefault != null && layoutDefault.booleanValue()) {
            Layout requestedLayout = (Layout)request.getAttribute("REQUESTED_LAYOUT");
            if (requestedLayout != null) {
                String redirectParam = "redirect";
                if (Validator.isNotNull((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) {
                    redirectParam = PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME) + redirectParam;
                }
                String authLoginURL = null;
                if (PrefsPropsUtil.getBoolean(themeDisplay.getCompanyId(), "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED)) {
                    authLoginURL = themeDisplay.getURLSignIn();
                }
                if (Validator.isNull(authLoginURL)) {
                    authLoginURL = PortalUtil.getCommunityLoginURL((ThemeDisplay)themeDisplay);
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PropsValues.AUTH_LOGIN_URL;
                }
                if (Validator.isNull((String)authLoginURL)) {
                    PortletURL loginURL = LoginUtil.getLoginURL(request, themeDisplay.getPlid());
                    authLoginURL = loginURL.toString();
                }
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)redirectParam, (String)currentURL);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect requested layout to " + authLoginURL));
                }
                response.sendRedirect(authLoginURL);
            } else {
                String redirect = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect default layout to " + redirect));
                }
                response.sendRedirect(redirect);
            }
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("p_l_id is " + plid));
        }
        if (plid > 0L) {
            return this.processLayout(mapping, request, response, plid);
        }
        try {
            this.forwardLayout(request);
            return mapping.findForward("/common/forward_jsp.jsp");
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void forwardLayout(HttpServletRequest request) throws Exception {
        String forwardURL;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long plid = 0L;
        String layoutFriendlyURL = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (layout != null) {
            plid = layout.getPlid();
            layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNull(forwardURL = layoutFriendlyURL)) {
            forwardURL = themeDisplay.getPathMain() + "/portal/layout?p_l_id=" + plid;
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
            }
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
                forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward layout to " + forwardURL));
        }
        request.setAttribute("FORWARD_URL", (Object)forwardURL);
    }

    protected List<LayoutTypePortlet> getLayoutTypePortlets(long groupId, boolean privateLayout) throws Exception {
        ArrayList<LayoutTypePortlet> layoutTypePortlets = new ArrayList<LayoutTypePortlet>();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (String)"portlet");
        for (Layout layout : layouts) {
            if (!layout.getType().equals("portlet")) continue;
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlets.add(layoutTypePortlet);
        }
        return layoutTypePortlets;
    }

    protected void includeLayoutContent(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay, Layout layout) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        String path = "/html";
        if (BrowserSnifferUtil.isWap((HttpServletRequest)request)) {
            path = "/wap";
        }
        path = themeDisplay.isStateExclusive() || Validator.isNotNull((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id")) ? (layout.getType().equals("panel") ? path + "/portal/layout/view/panel.jsp" : (layout.getType().equals("control_panel") ? path + "/portal/layout/view/control_panel.jsp" : path + "/portal/layout/view/portlet.jsp")) : path + PortalUtil.getLayoutViewPage((Layout)layout);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        StringServletResponse stringResponse = new StringServletResponse(response);
        requestDispatcher.include((ServletRequest)request, (ServletResponse)stringResponse);
        request.setAttribute("LAYOUT_CONTENT", (Object)stringResponse.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(PortletRequestImpl portletRequestImpl, StateAwareResponseImpl stateAwareResponseImpl, List<LayoutTypePortlet> layoutTypePortlets, LayoutTypePortlet layoutTypePortlet, Portlet portlet, Event event) throws Exception {
        HttpServletRequest request = portletRequestImpl.getHttpServletRequest();
        HttpServletResponse response = stateAwareResponseImpl.getHttpServletResponse();
        HttpSession session = request.getSession();
        String portletId = portlet.getPortletId();
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        WindowState windowState = null;
        windowState = layoutTypePortlet.hasStateMaxPortletId(portletId) ? WindowState.MAXIMIZED : (layoutTypePortlet.hasStateMinPortletId(portletId) ? WindowState.MINIMIZED : WindowState.NORMAL);
        PortletMode portletMode = null;
        portletMode = layoutTypePortlet.hasModeAboutPortletId(portletId) ? LiferayPortletMode.ABOUT : (layoutTypePortlet.hasModeConfigPortletId(portletId) ? LiferayPortletMode.CONFIG : (layoutTypePortlet.hasModeEditPortletId(portletId) ? PortletMode.EDIT : (layoutTypePortlet.hasModeEditDefaultsPortletId(portletId) ? LiferayPortletMode.EDIT_DEFAULTS : (layoutTypePortlet.hasModeEditGuestPortletId(portletId) ? LiferayPortletMode.EDIT_GUEST : (layoutTypePortlet.hasModeHelpPortletId(portletId) ? PortletMode.HELP : (layoutTypePortlet.hasModePreviewPortletId(portletId) ? LiferayPortletMode.PREVIEW : (layoutTypePortlet.hasModePrintPortletId(portletId) ? LiferayPortletMode.PRINT : PortletMode.VIEW)))))));
        User user = stateAwareResponseImpl.getUser();
        Layout layout = stateAwareResponseImpl.getLayout();
        PortletPreferencesImpl portletPreferences = portletRequestImpl.getPreferencesImpl();
        EventRequestImpl eventRequestImpl = EventRequestFactory.create(request, portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
        eventRequestImpl.setEvent(event);
        EventResponseImpl eventResponseImpl = EventResponseFactory.create(eventRequestImpl, response, portletId, user, layout);
        eventRequestImpl.defineObjects(portletConfig, (PortletResponse)eventResponseImpl);
        try {
            InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portletId, LanguageUtil.getLanguageId((PortletRequest)eventRequestImpl));
            invokerPortlet.processEvent((EventRequest)eventRequestImpl, (EventResponse)eventResponseImpl);
            if (eventResponseImpl.isCalledSetRenderParameter()) {
                HashMap<String, String[]> renderParameterMap = new HashMap<String, String[]>();
                MapUtil.copy(eventResponseImpl.getRenderParameterMap(), renderParameterMap);
                RenderParametersPool.put(request, layout.getPlid(), portletId, renderParameterMap);
            }
            this.processEvents(eventRequestImpl, eventResponseImpl, layoutTypePortlets);
        }
        finally {
            eventRequestImpl.cleanUp();
        }
    }

    protected void processEvents(PortletRequestImpl portletRequestImpl, StateAwareResponseImpl stateAwareResponseImpl, List<LayoutTypePortlet> layoutTypePortlets) throws Exception {
        List<Event> events = stateAwareResponseImpl.getEvents();
        if (events.size() == 0) {
            return;
        }
        for (Event event : events) {
            QName qName = event.getQName();
            for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
                List portlets = layoutTypePortlet.getPortlets();
                for (Portlet portlet : portlets) {
                    com.liferay.portal.kernel.xml.QName processingQName = portlet.getProcessingEvent(qName.getNamespaceURI(), qName.getLocalPart());
                    if (processingQName == null) continue;
                    this.processEvent(portletRequestImpl, stateAwareResponseImpl, layoutTypePortlets, layoutTypePortlet, portlet, event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward processLayout(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, long plid) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        try {
            ActionForward actionForward;
            Layout layout = themeDisplay.getLayout();
            boolean resetLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_l_reset", (boolean)PropsValues.LAYOUT_DEFAULT_P_L_RESET);
            String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
            Layout previousLayout = (Layout)session.getAttribute("PREVIOUS_LAYOUT");
            if (previousLayout == null || layout.getPlid() != previousLayout.getPlid()) {
                session.setAttribute("PREVIOUS_LAYOUT", (Object)layout);
            }
            if (!PropsValues.TCK_URL && resetLayout && (Validator.isNull((String)portletId) || previousLayout != null && layout.getPlid() != previousLayout.getPlid())) {
                RenderParametersPool.clear(request, plid);
            }
            if (themeDisplay.isLifecycleAction()) {
                Portlet portlet = this.processPortletRequest(request, response, "ACTION_PHASE");
                if (portlet != null) {
                    ActionResponseImpl actionResponseImpl = (ActionResponseImpl)request.getAttribute("javax.portlet.response");
                    String redirectLocation = actionResponseImpl.getRedirectLocation();
                    if (Validator.isNotNull((String)redirectLocation)) {
                        response.sendRedirect(redirectLocation);
                        ActionForward actionForward2 = null;
                        return actionForward2;
                    }
                    if (portlet.isActionURLRedirect()) {
                        this.redirectActionURL(request, response, actionResponseImpl, portlet);
                        ActionForward actionForward3 = null;
                        return actionForward3;
                    }
                }
            } else if (themeDisplay.isLifecycleRender()) {
                this.processPortletRequest(request, response, "RENDER_PHASE");
            }
            if (themeDisplay.isLifecycleResource()) {
                this.processPortletRequest(request, response, "RESOURCE_PHASE");
                actionForward = null;
                return actionForward;
            }
            if (response.isCommitted()) {
                actionForward = null;
                return actionForward;
            }
            if (layout != null) {
                this.includeLayoutContent(request, response, themeDisplay, layout);
                if (themeDisplay.isStateExclusive()) {
                    this.renderExclusive(request, response, themeDisplay);
                    actionForward = null;
                    return actionForward;
                }
            }
            actionForward = mapping.findForward("portal.layout");
            return actionForward;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            ActionForward actionForward = null;
            return actionForward;
        }
        finally {
            PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
            if (portletRequest != null) {
                PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
                portletRequestImpl.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Portlet processPortletRequest(HttpServletRequest request, HttpServletResponse response, String lifecycle) throws Exception {
        session = request /* !! */ .getSession();
        companyId = PortalUtil.getCompanyId((HttpServletRequest)request /* !! */ );
        user = PortalUtil.getUser((HttpServletRequest)request /* !! */ );
        layout = (Layout)request /* !! */ .getAttribute("LAYOUT");
        portletId = ParamUtil.getString((HttpServletRequest)request /* !! */ , (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet == null) {
            return null;
        }
        themeDisplay = (ThemeDisplay)request /* !! */ .getAttribute("THEME_DISPLAY");
        themeDisplay.setScopeGroupId(PortalUtil.getScopeGroupId((HttpServletRequest)request /* !! */ , (String)portletId));
        servletContext = (ServletContext)request /* !! */ .getAttribute("CTX");
        invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        if (user != null) {
            InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portletId, LanguageUtil.getLanguageId((HttpServletRequest)request /* !! */ ));
        }
        portletConfig = PortletConfigFactory.create(portlet, servletContext);
        portletContext = portletConfig.getPortletContext();
        windowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)request /* !! */ , (String)"p_p_state"));
        portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)request /* !! */ , (String)"p_p_mode"));
        portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request /* !! */ , (String)portletId);
        portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
        this.processPublicRenderParameters(request /* !! */ , layout, portlet);
        if (lifecycle.equals("ACTION_PHASE")) {
            contentType = request /* !! */ .getHeader("Content-Type");
            if (LayoutAction._log.isDebugEnabled()) {
                LayoutAction._log.debug((Object)("Content type " + contentType));
            }
            uploadRequest = null;
            try {
                if (contentType != null && contentType.startsWith("multipart/form-data")) {
                    invokerPortletConfigImpl = (PortletConfigImpl)invokerPortlet.getPortletConfig();
                    if (invokerPortlet.isStrutsPortlet() || invokerPortletConfigImpl != null && !invokerPortletConfigImpl.isWARFile()) {
                        uploadRequest = new UploadServletRequestImpl(request /* !! */ );
                        request /* !! */  = uploadRequest;
                    }
                }
                actionRequestImpl = ActionRequestFactory.create(request /* !! */ , portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
                actionResponseImpl = ActionResponseFactory.create(actionRequestImpl, response, portletId, user, layout, windowState, portletMode);
                actionRequestImpl.defineObjects(portletConfig, (PortletResponse)actionResponseImpl);
                invokerPortlet.processAction((ActionRequest)actionRequestImpl, (ActionResponse)actionResponseImpl);
                actionResponseImpl.transferHeaders(response);
                RenderParametersPool.put(request /* !! */ , layout.getPlid(), portletId, actionResponseImpl.getRenderParameterMap());
                layoutTypePortlets = null;
                if (actionResponseImpl.getEvents().isEmpty()) ** GOTO lbl63
                if (PropsValues.PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET) {
                    layoutTypePortlets = this.getLayoutTypePortlets(layout.getGroupId(), layout.isPrivateLayout());
                } else if (layout.getType().equals("portlet")) {
                    layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                    layoutTypePortlets = new ArrayList<LayoutTypePortlet>();
                    layoutTypePortlets.add(layoutTypePortlet);
                }
                this.processEvents(actionRequestImpl, actionResponseImpl, layoutTypePortlets);
                actionRequestImpl.defineObjects(portletConfig, (PortletResponse)actionResponseImpl);
            }
            finally {
                if (uploadRequest != null) {
                    uploadRequest.cleanUp();
                }
            }
        } else if (lifecycle.equals("RENDER_PHASE") || lifecycle.equals("RESOURCE_PHASE")) {
            PortalUtil.updateWindowState((String)portletId, (User)user, (Layout)layout, (WindowState)windowState, (HttpServletRequest)request /* !! */ );
            PortalUtil.updatePortletMode((String)portletId, (User)user, (Layout)layout, (PortletMode)portletMode, (HttpServletRequest)request /* !! */ );
        }
lbl63:
        // 5 sources

        if (lifecycle.equals("RESOURCE_PHASE")) {
            portletDisplay = themeDisplay.getPortletDisplay();
            portletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletDisplay.setId(portletId);
            portletDisplay.setRootPortletId(portlet.getRootPortletId());
            portletDisplay.setInstanceId(portlet.getInstanceId());
            portletDisplay.setResourcePK(portletPrimaryKey);
            portletDisplay.setPortletName(portletConfig.getPortletName());
            portletDisplay.setNamespace(PortalUtil.getPortletNamespace((String)portletId));
            resourceRequestImpl = ResourceRequestFactory.create(request /* !! */ , portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
            resourceResponseImpl = ResourceResponseFactory.create(resourceRequestImpl, response, portletId, companyId);
            resourceRequestImpl.defineObjects(portletConfig, (PortletResponse)resourceResponseImpl);
            invokerPortlet.serveResource((ResourceRequest)resourceRequestImpl, (ResourceResponse)resourceResponseImpl);
        }
        return portlet;
    }

    protected void processPublicRenderParameters(HttpServletRequest request, Layout layout, Portlet portlet) {
        Map<String, String[]> publicRenderParameters = PublicRenderParametersPool.get(request, layout.getPlid());
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            PublicRenderParameter publicRenderParameter;
            String name = (String)enu.nextElement();
            String[] values = request.getParameterValues(name);
            com.liferay.portal.kernel.xml.QName qName = PortletQNameUtil.getQName((String)name);
            if (qName == null || (publicRenderParameter = portlet.getPublicRenderParameter(qName.getNamespaceURI(), qName.getLocalPart())) == null) continue;
            if (name.startsWith("p_r_p_")) {
                publicRenderParameters.put(PortletQNameUtil.getKey((com.liferay.portal.kernel.xml.QName)qName), values);
                continue;
            }
            publicRenderParameters.remove(PortletQNameUtil.getKey((com.liferay.portal.kernel.xml.QName)qName));
        }
    }

    protected void redirectActionURL(HttpServletRequest request, HttpServletResponse response, ActionResponseImpl actionResponseImpl, Portlet portlet) throws Exception {
        ActionRequestImpl actionRequestImpl = (ActionRequestImpl)request.getAttribute("javax.portlet.request");
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        PortletURLImpl portletURL = new PortletURLImpl(actionRequestImpl, actionRequestImpl.getPortletName(), layout.getLayoutId(), "RENDER_PHASE");
        Map<String, String[]> renderParameters = actionResponseImpl.getRenderParameterMap();
        for (Map.Entry<String, String[]> entry : renderParameters.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            portletURL.setParameter(key, value);
        }
        response.sendRedirect(((Object)portletURL).toString());
    }

    protected void renderExclusive(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay) throws Exception {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)request.getAttribute("javax.portlet.request");
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)request.getAttribute("javax.portlet.response");
        StringServletResponse stringResponse = (StringServletResponse)renderRequestImpl.getAttribute("STRING_SERVLET_RESPONSE");
        renderResponseImpl.transferHeaders(response);
        if (stringResponse.isCalledGetOutputStream()) {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(stringResponse.getUnsyncByteArrayOutputStream().toByteArray());
            ServletResponseUtil.sendFile((HttpServletResponse)response, (String)renderResponseImpl.getResourceName(), (InputStream)is, (String)renderResponseImpl.getContentType());
        } else {
            byte[] content = stringResponse.getString().getBytes("UTF-8");
            ServletResponseUtil.sendFile((HttpServletResponse)response, (String)renderResponseImpl.getResourceName(), (byte[])content, (String)renderResponseImpl.getContentType());
        }
        renderRequestImpl.cleanUp();
    }
}

