/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.util.servlet.ServletResponseUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PortletURLAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String portletURL = this.getPortletURL(request);
            ServletResponseUtil.write((HttpServletResponse)response, (String)portletURL);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        return null;
    }

    protected String getPortletURL(HttpServletRequest request) throws Exception {
        String parameterMapString;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        String cacheability = ParamUtil.getString((HttpServletRequest)request, (String)"cacheability");
        boolean copyCurrentRenderParameters = ParamUtil.getBoolean((HttpServletRequest)request, (String)"copyCurrentRenderParameters");
        long doAsUserId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId");
        boolean encrypt = ParamUtil.getBoolean((HttpServletRequest)request, (String)"encrypt");
        boolean escapeXml = ParamUtil.getBoolean((HttpServletRequest)request, (String)"escapeXml");
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"lifecycle");
        String name = ParamUtil.getString((HttpServletRequest)request, (String)"name");
        boolean portletConfiguration = ParamUtil.getBoolean((HttpServletRequest)request, (String)"portletConfiguration");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"portletId");
        String portletMode = ParamUtil.getString((HttpServletRequest)request, (String)"portletMode");
        String resourceId = ParamUtil.getString((HttpServletRequest)request, (String)"resourceId");
        String returnToFullPageURL = ParamUtil.getString((HttpServletRequest)request, (String)"returnToFullPageURL");
        boolean secure = ParamUtil.getBoolean((HttpServletRequest)request, (String)"secure");
        String windowState = ParamUtil.getString((HttpServletRequest)request, (String)"windowState");
        PortletURLImpl portletURL = new PortletURLImpl(request, portletId, themeDisplay.getPlid(), lifecycle);
        if (Validator.isNotNull((String)cacheability)) {
            portletURL.setCacheability(cacheability);
        }
        portletURL.setCopyCurrentRenderParameters(copyCurrentRenderParameters);
        if (doAsUserId > 0L) {
            portletURL.setDoAsUserId(doAsUserId);
        }
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            portletURL.setDoAsUserLanguageId(doAsUserLanguageId);
        }
        portletURL.setEncrypt(encrypt);
        portletURL.setEscapeXml(escapeXml);
        if (lifecycle.equals("ACTION_PHASE") && Validator.isNotNull((String)name)) {
            portletURL.setParameter("javax.portlet.action", name);
        }
        portletURL.setPortletId(portletId);
        if (portletConfiguration) {
            String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
            String previewWidth = ParamUtil.getString((HttpServletRequest)request, (String)"previewWidth");
            portletURL.setParameter("struts_action", "/portlet_configuration/edit_configuration");
            portletURL.setParameter("returnToFullPageURL", returnToFullPageURL);
            portletURL.setParameter("portletResource", portletResource);
            portletURL.setParameter("previewWidth", previewWidth);
        }
        if (Validator.isNotNull((String)portletMode)) {
            portletURL.setPortletMode(PortletModeFactory.getPortletMode((String)portletMode));
        }
        if (Validator.isNotNull((String)resourceId)) {
            portletURL.setResourceID(resourceId);
        }
        if (!themeDisplay.isStateMaximized() && Validator.isNotNull((String)returnToFullPageURL)) {
            portletURL.setParameter("returnToFullPageURL", returnToFullPageURL);
        }
        portletURL.setSecure(secure);
        if (Validator.isNotNull((String)windowState)) {
            portletURL.setWindowState(WindowStateFactory.getWindowState((String)windowState));
        }
        if (Validator.isNotNull((String)(parameterMapString = ParamUtil.getString((HttpServletRequest)request, (String)"parameterMap")))) {
            Map parameterMap = (Map)JSONFactoryUtil.deserialize((String)parameterMapString);
            for (String paramName : parameterMap.keySet()) {
                String paramValue = (String)parameterMap.get(paramName);
                portletURL.setParameter(paramName, paramValue);
            }
        }
        return portletURL.toString();
    }
}

