/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.action.RenderPortletAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.servlet.DynamicServletRequest;
import com.liferay.util.servlet.ServletResponseUtil;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdateLayoutAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        boolean updateLayout = true;
        boolean deletePortlet = false;
        if (cmd.equals("add")) {
            portletId = layoutTypePortlet.addPortletId(userId, portletId);
            String columnId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_col_id");
            int columnPos = ParamUtil.getInteger((HttpServletRequest)request, (String)"p_p_col_pos");
            if (Validator.isNotNull((String)columnId) && Validator.isNotNull((String)portletId)) {
                layoutTypePortlet.movePortletId(userId, portletId, columnId, columnPos);
            }
        } else if (cmd.equals("delete")) {
            if (layoutTypePortlet.hasPortletId(portletId)) {
                deletePortlet = true;
                layoutTypePortlet.removePortletId(userId, portletId);
            }
        } else if (cmd.equals("drag")) {
            if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)"UPDATE")) {
                String height = ParamUtil.getString((HttpServletRequest)request, (String)"height");
                String width = ParamUtil.getString((HttpServletRequest)request, (String)"width");
                String top = ParamUtil.getString((HttpServletRequest)request, (String)"top");
                String left = ParamUtil.getString((HttpServletRequest)request, (String)"left");
                PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                StringBuilder sb = new StringBuilder();
                sb.append("height=" + height + "\n");
                sb.append("width=" + width + "\n");
                sb.append("top=" + top + "\n");
                sb.append("left=" + left + "\n");
                preferences.setValue("portlet-freeform-styles", sb.toString());
                preferences.store();
            }
        } else if (cmd.equals("minimize")) {
            boolean restore = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_restore");
            if (restore) {
                layoutTypePortlet.removeStateMinPortletId(portletId);
            } else {
                layoutTypePortlet.addStateMinPortletId(portletId);
            }
            updateLayout = false;
        } else if (cmd.equals("move")) {
            String columnId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_col_id");
            int columnPos = ParamUtil.getInteger((HttpServletRequest)request, (String)"p_p_col_pos");
            layoutTypePortlet.movePortletId(userId, portletId, columnId, columnPos);
        } else if (cmd.equals("template")) {
            String layoutTemplateId = ParamUtil.getString((HttpServletRequest)request, (String)"layoutTemplateId");
            layoutTypePortlet.setLayoutTemplateId(userId, layoutTemplateId);
        }
        if (updateLayout) {
            layoutTypePortlet.resetStates();
            LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            if (deletePortlet) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                ResourceLocalServiceUtil.deleteResource((long)layout.getCompanyId(), (String)rootPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
            }
        } else {
            LayoutClone layoutClone = LayoutCloneFactory.getInstance();
            if (layoutClone != null) {
                layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
            }
        }
        if (ParamUtil.getBoolean((HttpServletRequest)request, (String)"refresh")) {
            return mapping.findForward("/common/referer_js.jsp");
        }
        if (cmd.equals("add") && portletId != null) {
            this.addPortlet(mapping, form, request, response, portletId);
        }
        return null;
    }

    protected void addPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String portletId) throws Exception {
        Action renderPortletAction = (Action)InstancePool.get((String)RenderPortletAction.class.getName());
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        DynamicServletRequest dynamicRequest = null;
        if (portlet.isPrivateRequestAttributes()) {
            String portletNamespace = PortalUtil.getPortletNamespace((String)portlet.getPortletId());
            dynamicRequest = new NamespaceServletRequest(request, portletNamespace, portletNamespace);
        } else {
            dynamicRequest = new DynamicServletRequest(request);
        }
        dynamicRequest.setParameter("p_p_id", portletId);
        String dataType = ParamUtil.getString((HttpServletRequest)request, (String)"dataType");
        if (dataType.equals("json")) {
            JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
            if (portlet.isAjaxable()) {
                StringServletResponse stringResponse = new StringServletResponse(response);
                renderPortletAction.execute(mapping, form, (HttpServletRequest)dynamicRequest, (HttpServletResponse)stringResponse);
                jsonObj.put("refresh", false);
                jsonObj.put("portletHTML", stringResponse.getString().trim());
            } else {
                jsonObj.put("refresh", true);
            }
            ServletResponseUtil.write((HttpServletResponse)response, (String)jsonObj.toString());
        } else {
            renderPortletAction.execute(mapping, form, (HttpServletRequest)dynamicRequest, response);
        }
    }
}

