/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertiesImpl
implements BeanProperties {
    private static Log _log = LogFactoryUtil.getLog(BeanPropertiesImpl.class);

    public void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public void copyProperties(Object source, Object target, Class<?> editable) {
        BeanUtils.copyProperties((Object)source, (Object)target, editable);
    }

    public void copyProperties(Object source, Object target, String[] ignoreProperties) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
    }

    public boolean getBoolean(Object bean, String param) {
        return this.getBoolean(bean, param, false);
    }

    public boolean getBoolean(Object bean, String param, boolean defaultValue) {
        Boolean beanValue = null;
        if (bean != null) {
            try {
                beanValue = (Boolean)PropertyUtils.getProperty((Object)bean, (String)param);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)nsme.getMessage());
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public double getDouble(Object bean, String param) {
        return this.getDouble(bean, param, 0.0);
    }

    public double getDouble(Object bean, String param, double defaultValue) {
        Double beanValue = null;
        if (bean != null) {
            try {
                beanValue = (Double)PropertyUtils.getProperty((Object)bean, (String)param);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)nsme.getMessage());
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public int getInteger(Object bean, String param) {
        return this.getInteger(bean, param, 0);
    }

    public int getInteger(Object bean, String param, int defaultValue) {
        Integer beanValue = null;
        if (bean != null) {
            try {
                beanValue = (Integer)PropertyUtils.getProperty((Object)bean, (String)param);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)nsme.getMessage());
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public long getLong(Object bean, String param) {
        return this.getLong(bean, param, 0L);
    }

    public long getLong(Object bean, String param, long defaultValue) {
        Long beanValue = null;
        if (bean != null) {
            try {
                beanValue = (Long)PropertyUtils.getProperty((Object)bean, (String)param);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)nsme.getMessage());
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public Object getObject(Object bean, String param) {
        return this.getObject(bean, param, null);
    }

    public Object getObject(Object bean, String param, Object defaultValue) {
        Object beanValue = null;
        if (bean != null) {
            try {
                beanValue = PropertyUtils.getProperty((Object)bean, (String)param);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)nsme.getMessage());
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public String getString(Object bean, String param) {
        return this.getString(bean, param, "");
    }

    public String getString(Object bean, String param, String defaultValue) {
        String beanValue = null;
        if (bean != null) {
            try {
                beanValue = (String)PropertyUtils.getProperty((Object)bean, (String)param);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)nsme.getMessage());
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        if (beanValue == null) {
            return defaultValue;
        }
        return beanValue;
    }

    public void setProperty(Object bean, String param, Object value) {
        try {
            PropertyUtils.setProperty((Object)bean, (String)param, (Object)value);
        }
        catch (NoSuchMethodException nsme) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsme.getMessage());
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }
}

