/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.EhcachePortalCache;
import com.liferay.portal.kernel.cache.BlockingPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.net.URL;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.management.ManagementService;

public class EhcachePortalCacheManager
implements PortalCacheManager {
    private static Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private String _configPropertyKey;
    private CacheManager _cacheManager;
    private MBeanServer _mbeanServer;
    private boolean _registerCacheManager = true;
    private boolean _registerCaches = true;
    private boolean _registerCacheConfigurations = true;
    private boolean _registerCacheStatistics = true;

    public void afterPropertiesSet() {
        URL url = this.getClass().getResource(PropsUtil.get(this._configPropertyKey));
        this._cacheManager = new CacheManager(url);
        if (PropsValues.EHCACHE_PORTAL_CACHE_MANAGER_JMX_ENABLED) {
            ManagementService.registerMBeans((CacheManager)this._cacheManager, (MBeanServer)this._mbeanServer, (boolean)this._registerCacheManager, (boolean)this._registerCaches, (boolean)this._registerCacheConfigurations, (boolean)this._registerCacheStatistics);
        }
    }

    public void clearAll() {
        this._cacheManager.clearAll();
    }

    public void destroy() throws Exception {
        this._cacheManager.shutdown();
    }

    public PortalCache getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache getCache(String name, boolean blocking) {
        Ehcache cache = this._cacheManager.getEhcache(name);
        if (cache == null) {
            try {
                this._cacheManager.addCache(name);
            }
            catch (ObjectExistsException oee) {
                // empty catch block
            }
            cache = this._cacheManager.getEhcache(name);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Cache name " + name + " is using implementation " + cache.getClass().getName()));
            }
        }
        EhcachePortalCache portalCache = new EhcachePortalCache(cache);
        if (PropsValues.EHCACHE_BLOCKING_CACHE_ALLOWED && blocking) {
            portalCache = new BlockingPortalCache((PortalCache)portalCache);
        }
        return portalCache;
    }

    public void setConfigPropertyKey(String configPropertyKey) {
        this._configPropertyKey = configPropertyKey;
    }

    public void setMBeanServer(MBeanServer server) {
        this._mbeanServer = server;
    }

    public void setRegisterCacheConfigurations(boolean registerCacheConfigurations) {
        this._registerCacheConfigurations = registerCacheConfigurations;
    }

    public void setRegisterCacheManager(boolean registerCacheManager) {
        this._registerCacheManager = registerCacheManager;
    }

    public void setRegisterCaches(boolean registerCaches) {
        this._registerCaches = registerCaches;
    }

    public void setRegisterCacheStatistics(boolean registerCacheStatistics) {
        this._registerCacheStatistics = registerCacheStatistics;
    }
}

