/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.MemoryPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryPortalCacheManager
implements PortalCacheManager {
    private int _cacheInitialCapacity = 10000;
    private int _cacheManagerInitialCapacity = 10000;
    private Map<String, PortalCache> _cacheMap;

    public void afterPropertiesSet() {
        this._cacheMap = new ConcurrentHashMap<String, PortalCache>(this._cacheManagerInitialCapacity);
    }

    public void clearAll() {
        this._cacheMap.clear();
    }

    public PortalCache getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache getCache(String name, boolean blocking) {
        PortalCache cache = this._cacheMap.get(name);
        if (cache == null) {
            cache = new MemoryPortalCache(this._cacheInitialCapacity);
            this._cacheMap.put(name, cache);
        }
        return cache;
    }

    public void setCacheInitialCapacity(int cacheInitialCapacity) {
        this._cacheInitialCapacity = cacheInitialCapacity;
    }

    public void setCacheManagerInitialCapacity(int cacheManagerInitialCapacity) {
        this._cacheManagerInitialCapacity = cacheManagerInitialCapacity;
    }
}

