/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.captcha.recaptcha;

import com.liferay.portal.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReCaptchaImpl
extends SimpleCaptchaImpl {
    private static final String _TAGLIB_PATH = "/html/taglib/ui/captcha/recaptcha.jsp";
    private static Log _log = LogFactoryUtil.getLog(ReCaptchaImpl.class);

    public void check(HttpServletRequest request) throws CaptchaTextException {
        if (!this.isEnabled(request)) {
            return;
        }
        String reCaptchaChallenge = ParamUtil.getString((HttpServletRequest)request, (String)"recaptcha_challenge_field");
        String reCaptchaResponse = ParamUtil.getString((HttpServletRequest)request, (String)"recaptcha_response_field");
        Http.Options options = new Http.Options();
        options.addPart("challenge", reCaptchaChallenge);
        options.addPart("privatekey", PropsValues.CAPTCHA_ENGINE_RECAPTCHA_KEY_PRIVATE);
        options.addPart("remoteip", request.getRemoteAddr());
        options.addPart("response", reCaptchaResponse);
        options.setLocation(PropsValues.CAPTCHA_ENGINE_RECAPTCHA_URL_VERIFY);
        options.setPost(true);
        String content = null;
        try {
            content = HttpUtil.URLtoString((Http.Options)options);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            throw new CaptchaTextException();
        }
        if (content == null) {
            _log.error((Object)"reCAPTCHA did not return a result");
            throw new CaptchaTextException();
        }
        String[] messages = content.split("\r?\n");
        if (messages.length < 1) {
            _log.error((Object)("reCAPTCHA did not return a valid result: " + content));
            throw new CaptchaTextException();
        }
        if (!GetterUtil.getBoolean((String)messages[0])) {
            throw new CaptchaTextException();
        }
    }

    public void check(PortletRequest portletRequest) throws CaptchaTextException {
        if (!this.isEnabled(portletRequest)) {
            return;
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        this.check(request);
    }

    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    public void serveImage(HttpServletRequest request, HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void serveImage(PortletRequest portletRequest, PortletResponse portletResponse) {
        throw new UnsupportedOperationException();
    }
}

