/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.cluster.messaging.ClusterForwardMessageListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.IPDetector;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterLinkImpl
implements ClusterLink {
    private static final String _LIFERAY_CHANNEL = "LIFERAY-CHANNEL-";
    private static final int _MAX_CHANNEL_COUNT = Priority.values().length;
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkImpl.class);
    private List<org.jgroups.Address> _addresses;
    private int _channelCount;
    private List<JChannel> _channels;
    private ClusterForwardMessageListener _clusterForwardMessageListener;

    public void afterPropertiesSet() {
        block6: {
            if (!PropsValues.CLUSTER_LINK_ENABLED) {
                return;
            }
            if (OSDetector.isUnix() && IPDetector.isSupportsV6() && !IPDetector.isPrefersV4() && _log.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("You are on an Unix server with IPv6 enabled. JGroups ");
                sb.append("may not work with IPv6. If you see a multicast ");
                sb.append("error, try adding java.net.preferIPv4Stack=true ");
                sb.append("as a JVM startup parameter.");
                _log.warn((Object)sb.toString());
            }
            this.initSystemProperties();
            try {
                this.initBindAddress();
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)"Failed to initialize outgoing IP address", (Throwable)ioe);
            }
        }
        try {
            this.initChannels();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void destory() {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return;
        }
        for (JChannel channel : this._channels) {
            channel.close();
        }
    }

    public List<Address> getAddresses() {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return Collections.EMPTY_LIST;
        }
        Vector jGroupsAddresses = this._channels.get(0).getView().getMembers();
        if (jGroupsAddresses == null) {
            return new ArrayList<Address>();
        }
        ArrayList<Address> addresses = new ArrayList<Address>(jGroupsAddresses.size());
        for (org.jgroups.Address address : jGroupsAddresses) {
            addresses.add(new AddressImpl(address));
        }
        return addresses;
    }

    public boolean isEnabled() {
        return PropsValues.CLUSTER_LINK_ENABLED;
    }

    public void sendMulticastMessage(Message message, Priority priority) {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return;
        }
        JChannel channel = this.getChannel(priority);
        try {
            channel.send(null, null, (Serializable)message);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send multicast message " + message), (Throwable)ce);
        }
    }

    public void sendUnicastMessage(Address address, Message message, Priority priority) {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return;
        }
        org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
        JChannel channel = this.getChannel(priority);
        try {
            channel.send(jGroupsAddress, null, (Serializable)message);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send unicast message:" + message), (Throwable)ce);
        }
    }

    public void setClusterForwardMessageListener(ClusterForwardMessageListener clusterForwardMessageListener) {
        this._clusterForwardMessageListener = clusterForwardMessageListener;
    }

    protected JChannel createChannel(int index, String properties) throws ChannelException {
        JChannel channel = new JChannel(properties);
        channel.setReceiver((Receiver)new ReceiverAdapter(){

            public void receive(org.jgroups.Message message) {
                if (!ClusterLinkImpl.this._addresses.contains(message.getSrc()) || message.getDest() != null) {
                    ClusterLinkImpl.this._clusterForwardMessageListener.receive((Message)message.getObject());
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Block received message " + message));
                }
            }

            public void viewAccepted(View view) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Cluster link accepted view " + view));
                }
            }
        });
        channel.connect(_LIFERAY_CHANNEL + index);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Create a new channel with properties " + channel.getProperties()));
        }
        return channel;
    }

    protected JChannel getChannel(Priority priority) {
        int channelIndex = priority.ordinal() * this._channelCount / _MAX_CHANNEL_COUNT;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Select channel number " + channelIndex + " for priority " + priority));
        }
        return this._channels.get(channelIndex);
    }

    protected void initBindAddress() throws IOException {
        String autodetectAddress = PropsValues.CLUSTER_LINK_AUTODETECT_ADDRESS;
        if (Validator.isNull((String)autodetectAddress)) {
            return;
        }
        String host = autodetectAddress;
        int port = 80;
        int index = autodetectAddress.indexOf(":");
        if (index != -1) {
            host = autodetectAddress.substring(0, index);
            port = GetterUtil.getInteger((String)autodetectAddress.substring(index + 1), (int)port);
        }
        String bindAddress = SocketUtil.getHostAddress((String)host, (int)port);
        System.setProperty("jgroups.bind_addr", bindAddress);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Set JGroups outgoing IP address to " + bindAddress + "}"));
        }
    }

    protected void initChannels() throws ChannelException {
        Properties properties = PropsUtil.getProperties("cluster.link.channel.properties", true);
        this._channelCount = properties.size();
        if (this._channelCount <= 0 || this._channelCount > _MAX_CHANNEL_COUNT) {
            throw new IllegalArgumentException("Channel count must be between 1 and " + _MAX_CHANNEL_COUNT);
        }
        this._addresses = new ArrayList<org.jgroups.Address>(this._channelCount);
        this._channels = new ArrayList<JChannel>(this._channelCount);
        ArrayList<String> keys = new ArrayList<String>(this._channelCount);
        for (Object key : properties.keySet()) {
            keys.add((String)key);
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String customName = (String)keys.get(i);
            String value = properties.getProperty(customName);
            JChannel channel = this.createChannel(i, value);
            this._addresses.add(channel.getLocalAddress());
            this._channels.add(channel);
        }
    }

    protected void initSystemProperties() {
        for (String systemProperty : PropsValues.CLUSTER_LINK_CHANNEL_SYSTEM_PROPERTIES) {
            int index = systemProperty.indexOf(":");
            if (index == -1) continue;
            String key = systemProperty.substring(0, index);
            String value = systemProperty.substring(index + 1);
            System.setProperty(key, value);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Setting system property {key=" + key + ", value=" + value + "}"));
        }
    }
}

