/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.documentlibrary.util.HookFactory;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class ConvertDocumentLibrary
extends ConvertProcess {
    private static final String[] _HOOKS = new String[]{"com.liferay.documentlibrary.util.AdvancedFileSystemHook", "com.liferay.documentlibrary.util.CMISHook", "com.liferay.documentlibrary.util.FileSystemHook", "com.liferay.documentlibrary.util.JCRHook", "com.liferay.documentlibrary.util.S3Hook"};
    private static Log _log = LogFactoryUtil.getLog(ConvertDocumentLibrary.class);
    private Hook _sourceHook;
    private String[] _tagsCategories = new String[0];
    private String[] _tagsEntries = new String[0];
    private Hook _targetHook;

    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    public String[] getParameterNames() {
        StringBuilder sb = new StringBuilder();
        sb.append("dl.hook.impl=");
        for (String hook : _HOOKS) {
            if (hook.equals(PropsValues.DL_HOOK_IMPL)) continue;
            sb.append(hook + ";");
        }
        return new String[]{sb.toString()};
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doConvert() throws Exception {
        this._sourceHook = HookFactory.getInstance();
        String[] values = this.getParameterValues();
        String targetHookClassName = values[0];
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        this._targetHook = (Hook)classLoader.loadClass(targetHookClassName).newInstance();
        this.migratePortlets();
        HookFactory.setInstance(this._targetHook);
        MaintenanceUtil.appendStatus("Please set dl.hook.impl in your portal-ext.properties to use " + targetHookClassName);
        PropsValues.DL_HOOK_IMPL = targetHookClassName;
    }

    protected void migrateDL() throws Exception {
        int count = DLFileEntryLocalServiceUtil.getDLFileEntriesCount();
        int pages = count / 1000;
        MaintenanceUtil.appendStatus("Migrating " + count + " document library files");
        for (int i = 0; i <= pages; ++i) {
            int start = i * 1000;
            int end = start + 1000;
            List dlFileEntries = DLFileEntryLocalServiceUtil.getDLFileEntries((int)start, (int)end);
            String portletId = "20";
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                long companyId = dlFileEntry.getCompanyId();
                long groupId = dlFileEntry.getGroupId();
                long repositoryId = dlFileEntry.getFolderId();
                this.migrateDLFileEntry(companyId, portletId, groupId, repositoryId, dlFileEntry);
            }
        }
    }

    protected void migrateDLFileEntry(long companyId, String portletId, long groupId, long repositoryId, DLFileEntry fileEntry) throws Exception {
        String fileName = fileEntry.getName();
        long fileEntryId = fileEntry.getFileEntryId();
        String properties = fileEntry.getLuceneProperties();
        List dlFileVersions = DLFileVersionLocalServiceUtil.getFileVersions((long)fileEntry.getFolderId(), (String)fileName);
        if (dlFileVersions.isEmpty()) {
            double versionNumber = 1.0;
            Date modifiedDate = fileEntry.getModifiedDate();
            this.migrateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, fileEntryId, properties, modifiedDate);
            return;
        }
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            double versionNumber = dlFileVersion.getVersion();
            Date modifiedDate = dlFileVersion.getCreateDate();
            this.migrateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, fileEntryId, properties, modifiedDate);
        }
    }

    protected void migrateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, double versionNumber, long fileEntryId, String properties, Date modifiedDate) {
        try {
            InputStream is = this._sourceHook.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
            if (versionNumber == 1.0) {
                this._targetHook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, this._tagsCategories, this._tagsEntries, is);
            } else {
                this._targetHook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, fileName, fileEntryId, properties, modifiedDate, this._tagsCategories, this._tagsEntries, is);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Migration failed for " + fileName), (Throwable)e);
        }
    }

    protected void migrateFiles(long companyId, String dirName, String[] fileNames) throws Exception {
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        double versionNumber = 1.0;
        long fileEntryId = 0L;
        String properties = "";
        Date modifiedDate = new Date();
        try {
            this._targetHook.addDirectory(companyId, repositoryId, dirName);
        }
        catch (DuplicateDirectoryException dde) {
            // empty catch block
        }
        for (String fileName : fileNames) {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            this.migrateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, fileEntryId, properties, modifiedDate);
        }
    }

    protected void migrateMB() throws Exception {
        int count = MBMessageLocalServiceUtil.getMBMessagesCount();
        int pages = count / 1000;
        MaintenanceUtil.appendStatus("Migrating message boards attachments in " + count + " messages");
        for (int i = 0; i <= pages; ++i) {
            int start = i * 1000;
            int end = start + 1000;
            List messages = MBMessageLocalServiceUtil.getMBMessages((int)start, (int)end);
            for (MBMessage message : messages) {
                this.migrateFiles(message.getCompanyId(), message.getAttachmentsDir(), message.getAttachmentsFiles());
            }
        }
    }

    protected void migratePortlets() throws Exception {
        this.migrateDL();
        this.migrateMB();
        this.migrateWiki();
    }

    protected void migrateWiki() throws Exception {
        int count = WikiPageLocalServiceUtil.getWikiPagesCount();
        int pages = count / 1000;
        MaintenanceUtil.appendStatus("Migrating wiki page attachments in " + count + " pages");
        for (int i = 0; i <= pages; ++i) {
            int start = i * 1000;
            int end = start + 1000;
            List wikiPages = WikiPageLocalServiceUtil.getWikiPages((int)start, (int)end);
            for (WikiPage wikiPage : wikiPages) {
                if (!wikiPage.isHead()) continue;
                this.migrateFiles(wikiPage.getCompanyId(), wikiPage.getAttachmentsDir(), wikiPage.getAttachmentsFiles());
            }
        }
    }
}

