/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.NoSuchResourceActionException;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.convert.util.PermissionView;
import com.liferay.portal.convert.util.ResourcePermissionView;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.impl.ResourcePermissionModelImpl;
import com.liferay.portal.model.impl.RoleModelImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.upgrade.util.Table;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;

public class ConvertPermissionAlgorithm
extends ConvertProcess {
    private static final String _EXT_OTHER_ROLES = ".others_roles";
    private static final String _EXT_RESOURCE_PERMISSION = ".resource_permission";
    private static final String _EXT_ROLE = ".role";
    private static final String _EXT_ROLES_PERMIMISSIONS = ".roles_permissions";
    private static final String _UPDATED = ".updated";
    private static final Log _log = LogFactoryUtil.getLog(ConvertPermissionAlgorithm.class);
    private Map<Long, Role[]> _defaultRolesMap = new HashMap<Long, Role[]>();
    private Map<Long, Group> _groupsMap = new HashMap<Long, Group>();
    private Map<Long, Role> _guestRolesMap = new HashMap<Long, Role>();
    private Set<Long> _guestUsersSet = new HashSet<Long>();
    private Map<Long, Role> _ownerRolesMap = new HashMap<Long, Role>();
    private Set<String> _rolesPermissions = new HashSet<String>();

    public String getDescription() {
        return "convert-legacy-permission-algorithm";
    }

    public boolean isEnabled() {
        boolean enabled = false;
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 6) {
            enabled = true;
        }
        return enabled;
    }

    protected void convertToBitwise() throws Exception {
        MaintenanceUtil.appendStatus("Generating ResourceAction and ResourcePermission data");
        Table table = new Table("ResourceCode", new Object[][]{{"name", new Integer(12)}});
        table.setSelectSQL("SELECT name FROM ResourceCode GROUP BY name");
        String tempFile = table.generateTempFile();
        UnsyncBufferedReader resourceNameReader = new UnsyncBufferedReader((Reader)new FileReader(tempFile));
        UnsyncBufferedWriter resourcePermissionWriter = new UnsyncBufferedWriter((Writer)new FileWriter(tempFile + _EXT_RESOURCE_PERMISSION));
        PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM = 6;
        try {
            String line = null;
            while (Validator.isNotNull((String)(line = resourceNameReader.readLine()))) {
                String[] values = StringUtil.split((String)line);
                String name = values[0];
                List<String> defaultActionIds = ResourceActionsUtil.getResourceActions(name);
                ResourceActionLocalServiceUtil.checkResourceActions((String)name, defaultActionIds);
                this.convertResourcePermission((Writer)resourcePermissionWriter, name);
            }
            resourcePermissionWriter.close();
            MaintenanceUtil.appendStatus("Updating ResourcePermission table");
            Table resourcePermissionTable = new Table("ResourcePermission", ResourcePermissionModelImpl.TABLE_COLUMNS);
            resourcePermissionTable.populateTable(tempFile + _EXT_RESOURCE_PERMISSION);
        }
        catch (Exception e) {
            PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM = 5;
            throw e;
        }
        finally {
            resourceNameReader.close();
            resourcePermissionWriter.close();
            FileUtil.delete((String)tempFile);
            FileUtil.delete((String)(tempFile + _EXT_RESOURCE_PERMISSION));
        }
        MaintenanceUtil.appendStatus("Cleaning up legacy tables");
        DB db = DBFactoryUtil.getDB();
        db.runSQL("DELETE FROM ResourceCode");
        db.runSQL("DELETE FROM Permission_");
        db.runSQL("DELETE FROM Resource_");
        db.runSQL("DELETE FROM Roles_Permissions");
        MaintenanceUtil.appendStatus("Converted to bitwise permission");
    }

    protected void convertToRBAC() throws Exception {
        this.initializeRBAC();
        this.convertPermissions(2, "Groups_Permissions", new String[]{"groupId"}, "Groups_Roles", new Object[][]{{"groupId", -5}, {"roleId", -5}});
        this.convertPermissions(3, "OrgGroupPermission", new String[]{"organizationId", "groupId"}, "OrgGroupRole", new Object[][]{{"organizationId", -5}, {"groupId", -5}, {"roleId", -5}});
        this.convertPermissions(1, "Users_Permissions", new String[]{"userId"}, "Users_Roles", new Object[][]{{"userId", -5}, {"roleId", -5}});
        PermissionCacheUtil.clearCache();
        PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM = 5;
        MaintenanceUtil.appendStatus("Converted to RBAC permission");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertGuestUsers(String legacyFile) throws Exception {
        UnsyncBufferedReader legacyFileReader = new UnsyncBufferedReader((Reader)new FileReader(legacyFile));
        UnsyncBufferedWriter legacyFileUpdatedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(legacyFile + _UPDATED));
        UnsyncBufferedWriter legacyFileExtRolesPermissionsWriter = new UnsyncBufferedWriter((Writer)new FileWriter(legacyFile + _EXT_ROLES_PERMIMISSIONS));
        try {
            String line = null;
            while (Validator.isNotNull((String)(line = legacyFileReader.readLine()))) {
                String[] values = StringUtil.split((String)line);
                long companyId = PermissionView.getCompanyId(values);
                long permissionId = PermissionView.getPermissionId(values);
                int scope = PermissionView.getScopeId(values);
                long userId = PermissionView.getPrimaryKey(values);
                if (scope == 4 && this._guestUsersSet.contains(userId)) {
                    long roleId = this._guestRolesMap.get(companyId).getRoleId();
                    String key = roleId + "_" + permissionId;
                    if (this._rolesPermissions.contains(key)) continue;
                    this._rolesPermissions.add(key);
                    legacyFileExtRolesPermissionsWriter.write(roleId + "," + permissionId + "\n");
                    continue;
                }
                legacyFileUpdatedWriter.write(line + "\n");
            }
        }
        finally {
            legacyFileReader.close();
            legacyFileUpdatedWriter.close();
            legacyFileExtRolesPermissionsWriter.close();
        }
        Table table = new Table("Roles_Permissions", new Object[][]{{"roleId", -5}, {"permissionId", -5}});
        table.populateTable(legacyFile + _EXT_ROLES_PERMIMISSIONS);
        FileUtil.delete((String)legacyFile);
        FileUtil.delete((String)(legacyFile + _EXT_ROLES_PERMIMISSIONS));
        return legacyFile + _UPDATED;
    }

    protected void convertPermissions(int type, String legacyName, String[] primKeys, String newName, Object[][] newColumns) throws Exception {
        MaintenanceUtil.appendStatus("Processing " + legacyName);
        PermissionView legacyTable = new PermissionView(legacyName, primKeys);
        String legacyFile = legacyTable.generateTempFile();
        if (legacyFile == null) {
            return;
        }
        if (type == 1) {
            legacyFile = this.convertGuestUsers(legacyFile);
            MaintenanceUtil.appendStatus("Converted guest users to guest roles");
        }
        this.convertRoles(legacyFile, type, newName, newColumns);
        MaintenanceUtil.appendStatus("Converted roles for " + legacyName);
        DB db = DBFactoryUtil.getDB();
        db.runSQL(legacyTable.getDeleteSQL());
        FileUtil.delete((String)legacyFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertResourcePermission(Writer writer, String name) throws Exception {
        ResourcePermissionView resourcePermissionView = new ResourcePermissionView(name);
        UnsyncBufferedReader resourcePermissionReader = null;
        String resourcePermissionFile = resourcePermissionView.generateTempFile();
        if (resourcePermissionFile == null) {
            return;
        }
        MultiValueMap mvp = new MultiValueMap();
        try {
            resourcePermissionReader = new UnsyncBufferedReader((Reader)new FileReader(resourcePermissionFile));
            String line = null;
            while (Validator.isNotNull((String)(line = resourcePermissionReader.readLine()))) {
                String[] values = StringUtil.split((String)line);
                String actionId = ResourcePermissionView.getActionId(values);
                long companyId = ResourcePermissionView.getCompanyId(values);
                int scope = ResourcePermissionView.getScope(values);
                String primKey = ResourcePermissionView.getPrimaryKey(values);
                long roleId = ResourcePermissionView.getRoleId(values);
                mvp.put((Object)new Tuple((Object)companyId, (Object)scope, (Object)primKey, (Object)roleId), (Object)actionId);
            }
        }
        finally {
            if (resourcePermissionReader != null) {
                resourcePermissionReader.close();
            }
            FileUtil.delete((String)resourcePermissionFile);
        }
        for (Tuple key : mvp.keySet()) {
            long resourcePermissionId = CounterLocalServiceUtil.increment((String)ResourcePermission.class.getName());
            long companyId = (Long)key.getObject(0);
            int scope = (Integer)key.getObject(1);
            String primKey = (String)key.getObject(2);
            long roleId = (Long)key.getObject(3);
            String[] actionIdArray = mvp.getCollection((Object)key).toArray(new String[0]);
            long actionIds = 0L;
            for (String actionId : actionIdArray) {
                try {
                    ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)name, (String)actionId);
                    actionIds |= resourceAction.getBitwiseValue();
                }
                catch (NoSuchResourceActionException nsrae) {
                    if (!_log.isWarnEnabled()) continue;
                    String msg = nsrae.getMessage();
                    _log.warn((Object)("Could not find resource action " + msg));
                }
            }
            writer.append(resourcePermissionId + ",");
            writer.append(companyId + ",");
            writer.append(name + ",");
            writer.append(scope + ",");
            writer.append(primKey + ",");
            writer.append(roleId + ",");
            writer.append(actionIds + "," + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertRoles(String legacyFile, int type, String newName, Object[][] newColumns) throws Exception {
        UnsyncBufferedReader legacyFileReader = new UnsyncBufferedReader((Reader)new FileReader(legacyFile));
        UnsyncBufferedWriter legacyFileExtRoleWriter = new UnsyncBufferedWriter((Writer)new FileWriter(legacyFile + _EXT_ROLE));
        UnsyncBufferedWriter legacyFileExtRolesPermissionsWriter = new UnsyncBufferedWriter((Writer)new FileWriter(legacyFile + _EXT_ROLES_PERMIMISSIONS));
        UnsyncBufferedWriter legacyFileExtOtherRolesWriter = new UnsyncBufferedWriter((Writer)new FileWriter(legacyFile + _EXT_OTHER_ROLES));
        try {
            MultiValueMap mvp = new MultiValueMap();
            String line = null;
            while (Validator.isNotNull((String)(line = legacyFileReader.readLine()))) {
                String[] values = StringUtil.split((String)line);
                long resourceId = PermissionView.getResourceId(values);
                mvp.put((Object)resourceId, (Object)values);
            }
            for (Long key : mvp.keySet()) {
                String curKey;
                ArrayList valuesList = new ArrayList(mvp.getCollection((Object)key));
                String[] values = (String[])valuesList.get(0);
                long companyId = PermissionView.getCompanyId(values);
                long groupId = PermissionView.getPrimaryKey(values);
                String name = PermissionView.getNameId(values);
                int scope = PermissionView.getScopeId(values);
                ArrayList<String> actionsIds = new ArrayList<String>();
                ArrayList<Long> permissionIds = new ArrayList<Long>();
                for (String[] curValues : valuesList) {
                    String actionId = PermissionView.getActionId(curValues);
                    long permissionId = PermissionView.getPermissionId(curValues);
                    actionsIds.add(actionId);
                    permissionIds.add(permissionId);
                }
                if (type != 3 && scope == 4) {
                    List<String> defaultActions = null;
                    defaultActions = type == 1 ? ResourceActionsUtil.getResourceActions(name) : ResourceActionsUtil.getResourceCommunityDefaultActions(name);
                    Role defaultRole = null;
                    if (type == 1) {
                        Collections.sort(actionsIds);
                        Collections.sort(defaultActions);
                        if (((Object)defaultActions).equals(actionsIds)) {
                            defaultRole = this._ownerRolesMap.get(companyId);
                        }
                    } else if (defaultActions.containsAll(actionsIds)) {
                        Role[] defaultRoles = this._defaultRolesMap.get(companyId);
                        Group group = this._groupsMap.get(groupId);
                        if (group == null) continue;
                        if (group.isCommunity()) {
                            defaultRole = defaultRoles[0];
                        } else if (group.isOrganization()) {
                            defaultRole = defaultRoles[1];
                        } else if (group.isUser() || group.isUserGroup()) {
                            defaultRole = defaultRoles[2];
                        }
                    }
                    if (defaultRole != null) {
                        long roleId = defaultRole.getRoleId();
                        for (Long permissionId : permissionIds) {
                            curKey = roleId + "_" + permissionId;
                            if (this._rolesPermissions.contains(curKey)) continue;
                            this._rolesPermissions.add(curKey);
                            legacyFileExtRolesPermissionsWriter.write(roleId + "," + permissionId + ",\n");
                        }
                        continue;
                    }
                }
                long roleId = CounterLocalServiceUtil.increment();
                String roleName = StringUtil.upperCaseFirstLetter((String)RoleConstants.getTypeLabel((int)type));
                roleName = roleName + " " + Long.toHexString(roleId);
                String[] roleColumns = new String[]{String.valueOf(roleId), String.valueOf(companyId), String.valueOf(ClassNameLocalServiceUtil.getClassNameId(Role.class)), String.valueOf(roleId), roleName, "", "Autogenerated role from portal upgrade", String.valueOf(type), "lfr-permission-algorithm-5"};
                for (int i = 0; i < roleColumns.length; ++i) {
                    legacyFileExtRoleWriter.write(roleColumns[i] + ",");
                    if (i != roleColumns.length - 1) continue;
                    legacyFileExtRoleWriter.write("\n");
                }
                for (Long permissionId : permissionIds) {
                    curKey = roleId + "_" + permissionId;
                    if (this._rolesPermissions.contains(curKey)) continue;
                    this._rolesPermissions.add(curKey);
                    legacyFileExtRolesPermissionsWriter.write(roleId + "," + permissionId + ",\n");
                }
                for (int i = 0; i < newColumns.length - 1; ++i) {
                    legacyFileExtOtherRolesWriter.write(values[i] + ",");
                }
                legacyFileExtOtherRolesWriter.write(roleId + ",\n");
            }
        }
        finally {
            legacyFileReader.close();
            legacyFileExtRoleWriter.close();
            legacyFileExtRolesPermissionsWriter.close();
            legacyFileExtOtherRolesWriter.close();
        }
        Table roleTable = new Table("Role_", RoleModelImpl.TABLE_COLUMNS);
        roleTable.populateTable(legacyFile + _EXT_ROLE);
        Table rolesPermissionsTable = new Table("Roles_Permissions", new Object[][]{{"roleId", -5}, {"permissionId", -5}});
        rolesPermissionsTable.populateTable(legacyFile + _EXT_ROLES_PERMIMISSIONS);
        Table othersRolesTable = new Table(newName, newColumns);
        othersRolesTable.populateTable(legacyFile + _EXT_OTHER_ROLES);
        FileUtil.delete((String)(legacyFile + _EXT_ROLE));
        FileUtil.delete((String)(legacyFile + _EXT_ROLES_PERMIMISSIONS));
        FileUtil.delete((String)(legacyFile + _EXT_OTHER_ROLES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConvert() throws Exception {
        try {
            BatchSessionUtil.setEnabled((boolean)true);
            this.initialize();
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
                this.convertToRBAC();
            }
            this.convertToBitwise();
            MaintenanceUtil.appendStatus("Please set permissions.user.check.algorithm in your portal-ext.properties to use algorithm 6");
        }
        finally {
            CacheRegistry.clear();
            PermissionCacheUtil.clearCache();
            BatchSessionUtil.setEnabled((boolean)false);
        }
    }

    protected void initialize() throws Exception {
        List resourceCodes = ResourceCodeLocalServiceUtil.getResourceCodes((int)-1, (int)-1);
        for (ResourceCode resourceCode : resourceCodes) {
            String name = resourceCode.getName();
            if (name.contains(".")) continue;
            ResourceActionsUtil.getPortletResourceActions(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeRBAC() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies();
        for (Company company : companies) {
            long companyId = company.getCompanyId();
            this._defaultRolesMap.put(companyId, new Role[]{RoleLocalServiceUtil.getRole((long)companyId, (String)"Community Member"), RoleLocalServiceUtil.getRole((long)companyId, (String)"Organization Member"), RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User")});
            Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
            this._guestRolesMap.put(companyId, guestRole);
            Role ownerRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            this._ownerRolesMap.put(companyId, ownerRole);
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            this._guestUsersSet.add(defaultUserId);
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("SELECT * FROM Roles_Permissions");
            rs = ps.executeQuery();
            while (rs.next()) {
                long roleId = rs.getLong("roleId");
                long permissionId = rs.getLong("permissionId");
                this._rolesPermissions.add(roleId + "_" + permissionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        List groups = GroupLocalServiceUtil.getGroups((int)-1, (int)-1);
        for (Group group : groups) {
            this._groupsMap.put(group.getGroupId(), group);
        }
    }
}

