/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.SystemException;
import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.dao.db.SybaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.velocity.VelocityUtil;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDB
implements DB {
    protected static String ALTER_COLUMN_TYPE = "alter_column_type ";
    protected static String ALTER_COLUMN_NAME = "alter_column_name ";
    protected static String DROP_PRIMARY_KEY = "drop primary key";
    protected static String[] REWORD_TEMPLATE = new String[]{"@table@", "@old-column@", "@new-column@", "@type@", "@nullable@"};
    protected static String[] TEMPLATE = new String[]{"##", "TRUE", "FALSE", "'01/01/1970'", "CURRENT_TIMESTAMP", " BLOB", " BOOLEAN", " DATE", " DOUBLE", " INTEGER", " LONG", " STRING", " TEXT", " VARCHAR", " IDENTITY", "COMMIT_TRANSACTION"};
    private static boolean _SUPPORTS_ALTER_COLUMN_NAME = true;
    private static boolean _SUPPORTS_ALTER_COLUMN_TYPE = true;
    private static boolean _SUPPORTS_DATE_MILLISECONDS = true;
    private static boolean _SUPPORTS_SCROLLABLE_RESULTS = true;
    private static boolean _SUPPORTS_UPDATE_WITH_INNER_JOIN;
    private static Log _log;
    private String _type;
    private boolean _supportsStringCaseSensitiveQuery;

    public void buildCreateFile(String databaseName) throws IOException {
        this.buildCreateFile(databaseName, 0);
        this.buildCreateFile(databaseName, 1);
        this.buildCreateFile(databaseName, 2);
    }

    public void buildCreateFile(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        File file = new File("../sql/create" + suffix + "/create" + suffix + "-" + this.getServerName() + ".sql");
        if (population != 2) {
            String content = this.buildCreateFileContent(databaseName, population);
            if (content != null) {
                FileUtil.write((File)file, (String)content);
            }
        } else {
            String content = this.buildCreateFileContent(databaseName, 1);
            if (content != null) {
                FileUtil.write((File)file, (String)content);
            }
            if ((content = this.buildCreateFileContent(databaseName + "1", 1)) != null) {
                FileUtil.write((File)file, (String)content, (boolean)false, (boolean)true);
            }
            if ((content = this.buildCreateFileContent(databaseName + "2", 1)) != null) {
                FileUtil.write((File)file, (String)content, (boolean)false, (boolean)true);
            }
        }
    }

    public abstract String buildSQL(String var1) throws IOException;

    public void buildSQLFile(String fileName) throws IOException {
        String template = this.buildTemplate(fileName);
        template = this.buildSQL(template);
        FileUtil.write((String)("../sql/" + fileName + "/" + fileName + "-" + this.getServerName() + ".sql"), (String)template);
    }

    public List<Index> getIndexes() throws SQLException {
        return Collections.EMPTY_LIST;
    }

    public String getTemplateFalse() {
        return this.getTemplate()[2];
    }

    public String getTemplateTrue() {
        return this.getTemplate()[1];
    }

    public String getType() {
        return this._type;
    }

    public long increment() throws SystemException {
        return CounterLocalServiceUtil.increment();
    }

    public boolean isSupportsAlterColumnName() {
        return _SUPPORTS_ALTER_COLUMN_NAME;
    }

    public boolean isSupportsAlterColumnType() {
        return _SUPPORTS_ALTER_COLUMN_TYPE;
    }

    public boolean isSupportsDateMilliseconds() {
        return _SUPPORTS_DATE_MILLISECONDS;
    }

    public boolean isSupportsScrollableResults() {
        return _SUPPORTS_SCROLLABLE_RESULTS;
    }

    public boolean isSupportsStringCaseSensitiveQuery() {
        return this._supportsStringCaseSensitiveQuery;
    }

    public boolean isSupportsUpdateWithInnerJoin() {
        return _SUPPORTS_UPDATE_WITH_INNER_JOIN;
    }

    public void runSQL(String sql) throws IOException, SQLException {
        this.runSQL(new String[]{sql});
    }

    public void runSQL(Connection con, String sql) throws IOException, SQLException {
        this.runSQL(con, new String[]{sql});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSQL(String[] sqls) throws IOException, SQLException {
        Connection con = DataAccess.getConnection();
        try {
            this.runSQL(con, sqls);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSQL(Connection con, String[] sqls) throws IOException, SQLException {
        Statement s = null;
        try {
            s = con.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                String sql = this.buildSQL(sqls[i]);
                if ((sql = sql.trim()).endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (sql.endsWith("go")) {
                    sql = sql.substring(0, sql.length() - 2);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)sql);
                }
                s.executeUpdate(sql);
                continue;
            }
        }
        finally {
            DataAccess.cleanUp((Statement)s);
        }
    }

    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        this.runSQLTemplate(path, true);
    }

    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + path);
        if (is == null) {
            is = classLoader.getResourceAsStream(path);
        }
        if (is == null) {
            _log.error((Object)("Invalid path " + path));
        }
        String template = StringUtil.read((InputStream)is);
        is.close();
        boolean evaluate = path.endsWith(".vm");
        this.runSQLTemplateString(template, evaluate, failOnError);
    }

    public void runSQLTemplateString(String template, boolean evaluate, boolean failOnError) throws IOException, NamingException, SQLException {
        if (evaluate) {
            try {
                template = this.evaluateVM(template);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("##")) continue;
            if (line.startsWith("@include ")) {
                int pos = line.indexOf(" ");
                String includeFileName = line.substring(pos + 1);
                Thread currentThread = Thread.currentThread();
                ClassLoader classLoader = currentThread.getContextClassLoader();
                InputStream is = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + includeFileName);
                if (is == null) {
                    is = classLoader.getResourceAsStream(includeFileName);
                }
                String include = StringUtil.read((InputStream)is);
                is.close();
                if (includeFileName.endsWith(".vm")) {
                    try {
                        include = this.evaluateVM(include);
                    }
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                    }
                }
                include = this.convertTimestamp(include);
                include = this.replaceTemplate(include, this.getTemplate());
                this.runSQLTemplateString(include, false, true);
                continue;
            }
            sb.append(line);
            if (!line.endsWith(";")) continue;
            String sql = sb.toString();
            sb = new StringBuilder();
            try {
                if (!sql.equals("COMMIT_TRANSACTION;")) {
                    this.runSQL(sql);
                    continue;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Skip commit sql");
            }
            catch (IOException ioe) {
                if (failOnError) {
                    throw ioe;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)ioe.getMessage());
            }
            catch (SQLException sqle) {
                if (failOnError) {
                    throw sqle;
                }
                if (!_log.isWarnEnabled()) continue;
                String message = GetterUtil.getString((String)sqle.getMessage());
                if (!message.startsWith("Duplicate key name")) {
                    _log.warn((Object)(message + ": " + sql));
                }
                if (!message.startsWith("Duplicate entry") && !message.startsWith("Specified key was too long")) continue;
                _log.error((Object)line);
            }
        }
        unsyncBufferedReader.close();
    }

    public void setSupportsStringCaseSensitiveQuery(boolean supportsStringCaseSensitiveQuery) {
        if (_log.isInfoEnabled()) {
            if (supportsStringCaseSensitiveQuery) {
                _log.info((Object)"Database supports case sensitive queries");
            } else {
                _log.info((Object)"Database does not support case sensitive queries");
            }
        }
        this._supportsStringCaseSensitiveQuery = supportsStringCaseSensitiveQuery;
    }

    public void updateIndexes(String tablesSQL, String indexesSQL, String indexesProperties, boolean dropIndexes) throws IOException, SQLException {
        List<Index> indexes = this.getIndexes();
        HashSet<String> validIndexNames = null;
        if (dropIndexes) {
            validIndexNames = this.dropIndexes(tablesSQL, indexesSQL, indexesProperties, indexes);
        } else {
            validIndexNames = new HashSet();
            for (Index index : indexes) {
                String indexName = index.getIndexName().toUpperCase();
                validIndexNames.add(indexName);
            }
        }
        this.addIndexes(indexesSQL, validIndexNames);
    }

    protected BaseDB(String type) {
        this._type = type;
    }

    protected void addIndexes(String indexesSQL, Set<String> validIndexNames) throws IOException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Adding indexes");
        }
        DB db = DBFactoryUtil.getDB();
        UnsyncBufferedReader bufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(indexesSQL));
        String sql = null;
        while ((sql = bufferedReader.readLine()) != null) {
            int y;
            int x;
            String indexName;
            if (Validator.isNull((String)sql) || validIndexNames.contains(indexName = sql.substring((x = sql.lastIndexOf(" ", (y = sql.indexOf(" on ")) - 1)) + 1, y))) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)sql);
            }
            try {
                db.runSQL(sql);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e.getMessage());
            }
        }
    }

    protected abstract String buildCreateFileContent(String var1, int var2) throws IOException;

    protected String[] buildColumnNameTokens(String line) {
        String[] words = StringUtil.split((String)line, (String)" ");
        if (words.length == 7) {
            words[5] = "not null;";
        }
        String[] template = new String[]{words[1], words[2], words[3], words[4], words[5]};
        return template;
    }

    protected String[] buildColumnTypeTokens(String line) {
        String[] words = StringUtil.split((String)line, (String)" ");
        String nullable = "";
        if (words.length == 6) {
            nullable = "not null;";
        } else if (words.length == 5) {
            nullable = words[4];
        } else if (words.length == 4) {
            nullable = "not null;";
            if (words[3].endsWith(";")) {
                words[3] = words[3].substring(0, words[3].length() - 1);
            }
        }
        String[] template = new String[]{words[1], words[2], "", words[3], nullable};
        return template;
    }

    protected String buildTemplate(String fileName) throws IOException {
        File file = new File("../sql/" + fileName + ".sql");
        String template = FileUtil.read((File)file);
        if (fileName.equals("portal") || fileName.equals("portal-minimal") || fileName.equals("update-5.0.1-5.1.0")) {
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("@include ")) {
                    int pos = line.indexOf(" ");
                    String includeFileName = line.substring(pos + 1);
                    File includeFile = new File("../sql/" + includeFileName);
                    if (!includeFile.exists()) continue;
                    String include = FileUtil.read((File)includeFile);
                    if (includeFileName.endsWith(".vm")) {
                        try {
                            include = this.evaluateVM(include);
                        }
                        catch (Exception e) {
                            _log.error((Object)e, (Throwable)e);
                        }
                    }
                    include = this.convertTimestamp(include);
                    include = this.replaceTemplate(include, this.getTemplate());
                    sb.append(include);
                    sb.append("\n\n");
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
            unsyncBufferedReader.close();
            template = sb.toString();
        }
        if (fileName.equals("indexes") && this instanceof SybaseDB) {
            template = this.removeBooleanIndexes(template);
        }
        return template;
    }

    protected String convertTimestamp(String data) {
        String s = null;
        s = this instanceof MySQLDB ? StringUtil.replace((String)data, (String)"SPECIFIC_TIMESTAMP_", (String)"") : data.replaceAll("SPECIFIC_TIMESTAMP_\\d+", "CURRENT_TIMESTAMP");
        return s;
    }

    protected Set<String> dropIndexes(String tablesSQL, String indexesSQL, String indexesProperties, List<Index> indexes) throws IOException, SQLException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Dropping stale indexes");
        }
        HashSet<String> validIndexNames = new HashSet<String>();
        if (indexes.isEmpty()) {
            return validIndexNames;
        }
        DB db = DBFactoryUtil.getDB();
        String type = db.getType();
        String tablesSQLLowerCase = tablesSQL.toLowerCase();
        String indexesSQLLowerCase = indexesSQL.toLowerCase();
        Properties indexesPropertiesObj = PropertiesUtil.load((String)indexesProperties);
        Enumeration<?> enu = indexesPropertiesObj.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = indexesPropertiesObj.getProperty(key);
            indexesPropertiesObj.setProperty(key.toLowerCase(), value);
        }
        for (Index index : indexes) {
            String indexNameUpperCase = index.getIndexName().toUpperCase();
            String indexNameLowerCase = indexNameUpperCase.toLowerCase();
            String tableName = index.getTableName();
            String tableNameLowerCase = tableName.toLowerCase();
            boolean unique = index.isUnique();
            validIndexNames.add(indexNameUpperCase);
            if (indexesPropertiesObj.containsKey(indexNameLowerCase) ? unique && indexesSQLLowerCase.contains("create unique index " + indexNameLowerCase + " ") || !unique && indexesSQLLowerCase.contains("create index " + indexNameLowerCase + " ") : !tablesSQLLowerCase.contains("create table " + tableNameLowerCase + " (")) continue;
            validIndexNames.remove(indexNameUpperCase);
            String sql = "drop index " + indexNameUpperCase;
            if (type.equals("mysql") || type.equals("sqlserver")) {
                sql = sql + " on " + tableName;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)sql);
            }
            db.runSQL(sql);
        }
        return validIndexNames;
    }

    protected String evaluateVM(String template) throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("counter", new SimpleCounter());
        template = VelocityUtil.evaluate(template, variables);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            line = line.trim();
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        template = sb.toString();
        template = StringUtil.replace((String)template, (String)"\n\n\n", (String)"\n\n");
        return template;
    }

    protected abstract String getServerName();

    protected String getSuffix(int type) {
        if (type == 1) {
            return "-minimal";
        }
        if (type == 2) {
            return "-sharded";
        }
        return "";
    }

    protected abstract String[] getTemplate();

    protected String readSQL(String fileName, String comments, String eol) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(new File(fileName)));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith(comments)) continue;
            if ((line = StringUtil.replace((String)line, (String[])new String[]{"\n", "\t"}, (String[])new String[]{"", ""})).endsWith(";")) {
                sb.append(line.substring(0, line.length() - 1));
                sb.append(eol);
                continue;
            }
            sb.append(line);
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    protected String removeBooleanIndexes(String data) throws IOException {
        String portalData = FileUtil.read((String)"../sql/portal-tables.sql");
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            boolean append = true;
            int x = line.indexOf(" on ");
            if (x != -1) {
                int y = line.indexOf(" (", x);
                String table = line.substring(x + 4, y);
                x = y + 2;
                y = line.indexOf(")", x);
                String[] columns = StringUtil.split((String)line.substring(x, y));
                x = portalData.indexOf("create table " + table + " (");
                y = portalData.indexOf(");", x);
                String portalTableData = portalData.substring(x, y);
                for (int i = 0; i < columns.length; ++i) {
                    if (portalTableData.indexOf(columns[i].trim() + " BOOLEAN") == -1) continue;
                    append = false;
                    break;
                }
            }
            if (!append) continue;
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    protected String removeInserts(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("insert into ") || line.startsWith("update ")) continue;
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    protected String removeLongInserts(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("insert into Image (") || line.startsWith("insert into JournalArticle (") || line.startsWith("insert into JournalStructure (") || line.startsWith("insert into JournalTemplate (")) continue;
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    protected String removeNull(String content) {
        content = StringUtil.replace((String)content, (String)" is null", (String)" IS NULL");
        content = StringUtil.replace((String)content, (String)" not null", (String)" not_null");
        content = StringUtil.replace((String)content, (String)" null", (String)"");
        content = StringUtil.replace((String)content, (String)" not_null", (String)" not null");
        return content;
    }

    protected String replaceTemplate(String template, String[] actual) {
        if (template == null || TEMPLATE == null || actual == null) {
            return null;
        }
        if (TEMPLATE.length != actual.length) {
            return template;
        }
        for (int i = 0; i < TEMPLATE.length; ++i) {
            template = TEMPLATE[i].equals("##") || TEMPLATE[i].equals("'01/01/1970'") ? template.replaceAll(TEMPLATE[i], actual[i]) : template.replaceAll("\\b" + TEMPLATE[i] + "\\b", actual[i]);
        }
        return template;
    }

    protected abstract String reword(String var1) throws IOException;

    static {
        _log = LogFactoryUtil.getLog(BaseDB.class);
    }
}

