/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;

public class DB2DB
extends BaseDB {
    private static String[] _DB2 = new String[]{"--", "1", "0", "'1970-01-01-00.00.00.000000'", "current timestamp", " blob(2000)", " smallint", " timestamp", " double", " integer", " bigint", " varchar(500)", " clob", " varchar", " generated always as identity", "commit"};
    private static boolean _SUPPORTS_ALTER_COLUMN_TYPE;
    private static boolean _SUPPORTS_SCROLLABLE_RESULTS;
    private static DB2DB _instance;

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeLongInserts(template);
        template = this.removeNull(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    public boolean isSupportsAlterColumnType() {
        return _SUPPORTS_ALTER_COLUMN_TYPE;
    }

    public boolean isSupportsScrollableResults() {
        return _SUPPORTS_SCROLLABLE_RESULTS;
    }

    public void runSQL(String template) throws IOException, SQLException {
        if (template.startsWith(ALTER_COLUMN_NAME) || template.startsWith(ALTER_COLUMN_TYPE)) {
            String[] alterSqls;
            String sql = this.buildSQL(template);
            for (String alterSql : alterSqls = StringUtil.split((String)sql, (String)";")) {
                if (alterSql.startsWith("-- ")) continue;
                this.runSQL(alterSql);
            }
        } else {
            super.runSQL(template);
        }
    }

    public void runSQL(String[] templates) throws IOException, SQLException {
        super.runSQL(templates);
        this._reorgTables(templates);
    }

    protected DB2DB() {
        super("db2");
    }

    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb.append("drop database " + databaseName + ";\n");
        sb.append("create database " + databaseName + ";\n");
        sb.append("connect to " + databaseName + ";\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-db2.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-db2.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-db2.sql"));
        return sb.toString();
    }

    protected String getServerName() {
        return "db2";
    }

    protected String[] getTemplate() {
        return _DB2;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                String[] template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ add column @new-column@ @type@;\n", (String[])REWORD_TEMPLATE, (String[])template);
                line = line + StringUtil.replace((String)"update @table@ set @new-column@ = @old-column@;\n", (String[])REWORD_TEMPLATE, (String[])template);
                line = line + StringUtil.replace((String)"alter table @table@ drop column @old-column@", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                line = "-- " + line;
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reorgTables(String[] templates) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        for (String template : templates) {
            if (!template.startsWith("alter table")) continue;
            tableNames.add(template.split(" ")[2]);
        }
        if (tableNames.size() == 0) {
            return;
        }
        Connection con = null;
        CallableStatement callStmt = null;
        try {
            con = DataAccess.getConnection();
            for (String tableName : tableNames) {
                String sql = "call sysproc.admin_cmd(?)";
                callStmt = con.prepareCall(sql);
                String param = "reorg table " + tableName;
                callStmt.setString(1, param);
                callStmt.execute();
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, callStmt);
        }
    }

    static {
        _instance = new DB2DB();
    }
}

