/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class DerbyDB
extends BaseDB {
    private static String[] _DERBY = new String[]{"--", "1", "0", "'1970-01-01-00.00.00.000000'", "current timestamp", " blob", " smallint", " timestamp", " double", " integer", " bigint", " varchar(4000)", " clob", " varchar", " generated always as identity", "commit"};
    private static boolean _SUPPORTS_ALTER_COLUMN_NAME;
    private static boolean _SUPPORTS_ALTER_COLUMN_TYPE;
    private static Log _log;
    private static DerbyDB _instance;

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeNull(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    public boolean isSupportsAlterColumnName() {
        return _SUPPORTS_ALTER_COLUMN_NAME;
    }

    public boolean isSupportsAlterColumnType() {
        return _SUPPORTS_ALTER_COLUMN_TYPE;
    }

    protected DerbyDB() {
        super("derby");
    }

    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb.append("drop database " + databaseName + ";\n");
        sb.append("create database " + databaseName + ";\n");
        sb.append("connect to " + databaseName + ";\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-derby.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-derby.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-derby.sql"));
        return sb.toString();
    }

    protected String getServerName() {
        return "derby";
    }

    protected String[] getTemplate() {
        return _DERBY;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith(ALTER_COLUMN_NAME) || line.startsWith(ALTER_COLUMN_TYPE)) {
                line = "-- " + line;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("This statement is not supported by Derby: " + line));
                }
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    static {
        _log = LogFactoryUtil.getLog(DerbyDB.class);
        _instance = new DerbyDB();
    }
}

