/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class HypersonicDB
extends BaseDB {
    private static String[] _HYPERSONIC = new String[]{"//", "true", "false", "'1970-01-01'", "now()", " binary", " bit", " timestamp", " double", " int", " bigint", " longvarchar", " longvarchar", " varchar", "", "commit"};
    private static HypersonicDB _instance = new HypersonicDB();

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    protected HypersonicDB() {
        super("hypersonic");
    }

    protected String buildCreateFileContent(String databaseName, int population) {
        return null;
    }

    protected String getServerName() {
        return "hypersonic";
    }

    protected String[] getTemplate() {
        return _HYPERSONIC;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ rename to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@ @nullable@;", (String[])REWORD_TEMPLATE, (String[])template);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

