/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class InformixDB
extends BaseDB {
    private static String[] _INFORMIX_TEMPLATE = new String[]{"--", "'T'", "'F'", "'1970-01-01'", "CURRENT YEAR TO FRACTION", " byte in table", " boolean", " datetime YEAR TO FRACTION", " float", " int", " int8", " lvarchar", " text", " varchar", "", "commit"};
    private static InformixDB _instance = new InformixDB();

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeNull(template);
        return template;
    }

    protected InformixDB() {
        super("informix");
    }

    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb.append("database sysmaster;\n");
        sb.append("drop database " + databaseName + ";\n");
        sb.append("create database " + databaseName + " WITH LOG;\n");
        sb.append("\n");
        sb.append("create procedure 'lportal'.isnull(test_string varchar)\n");
        sb.append("returning boolean;\n");
        sb.append("IF test_string IS NULL THEN\n");
        sb.append("\tRETURN 't';\n");
        sb.append("ELSE\n");
        sb.append("\tRETURN 'f';\n");
        sb.append("END IF\n");
        sb.append("end procedure;\n");
        sb.append("\n\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-informix.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-informix.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-informix.sql"));
        return sb.toString();
    }

    protected String getServerName() {
        return "informix";
    }

    protected String[] getTemplate() {
        return _INFORMIX_TEMPLATE;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        boolean createTable = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"rename column @table@.@old-column@ TO @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ modify (@old-column@ @type@);", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.indexOf("typeSettings text") > 0) {
                line = StringUtil.replace((String)line, (String)"typeSettings text", (String)"typeSettings lvarchar(4096)");
            } else if (line.indexOf("varchar(300)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(300)", (String)"lvarchar(300)");
            } else if (line.indexOf("varchar(500)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(500)", (String)"lvarchar(500)");
            } else if (line.indexOf("varchar(1000)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(1000)", (String)"lvarchar(1000)");
            } else if (line.indexOf("varchar(1024)") > 0) {
                line = StringUtil.replace((String)line, (String)"varchar(1024)", (String)"lvarchar(1024)");
            } else if (line.indexOf("1970-01-01") > 0) {
                line = StringUtil.replace((String)line, (String)"1970-01-01", (String)"1970-01-01 00:00:00.0");
            } else if (line.indexOf("create table") >= 0) {
                createTable = true;
            } else if (line.indexOf(");") >= 0 && createTable) {
                line = StringUtil.replace((String)line, (String)");", (String)")\nextent size 16 next size 16\nlock mode row;");
                createTable = false;
            } else if (line.indexOf("commit;") >= 0) {
                line = "";
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

