/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class IngresDB
extends BaseDB {
    private static String[] _INGRES = new String[]{"--", "1", "0", "'1970-01-01'", "date('now')", " byte varying", " tinyint", " timestamp", " float", " integer", " bigint", " varchar(1000)", " long varchar", " varchar", "", "commit;\\g"};
    private static boolean _SUPPORTS_ALTER_COLUMN_NAME;
    private static Log _log;
    private static IngresDB _instance;

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\n", (String)"'+x'0a'+'");
        return template;
    }

    public boolean isSupportsAlterColumnName() {
        return _SUPPORTS_ALTER_COLUMN_NAME;
    }

    protected IngresDB() {
        super("ingres");
    }

    protected String buildCreateFileContent(String databaseName, int population) {
        return null;
    }

    protected String getServerName() {
        return "ingres";
    }

    protected String[] getTemplate() {
        return _INGRES;
    }

    protected String replaceTemplate(String template, String[] actual) {
        if (template == null || TEMPLATE == null || actual == null) {
            return null;
        }
        if (TEMPLATE.length != actual.length) {
            return template;
        }
        for (int i = 0; i < TEMPLATE.length; ++i) {
            template = TEMPLATE[i].equals("##") || TEMPLATE[i].equals("'01/01/1970'") ? template.replaceAll(TEMPLATE[i], actual[i]) : (TEMPLATE[i].equals("COMMIT_TRANSACTION") ? StringUtil.replace((String)template, (String)(TEMPLATE[i] + ";"), (String)actual[i]) : template.replaceAll("\\b" + TEMPLATE[i] + "\\b", actual[i]));
        }
        return template;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                line = "-- " + line;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("This statement is not supported by Ingres: " + line));
                }
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                String[] template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.indexOf(DROP_PRIMARY_KEY) != -1) {
                String[] tokens = StringUtil.split((String)line, (String)" ");
                line = StringUtil.replace((String)"alter table @table@ drop constraint @table@_pkey;", (String)"@table@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    static {
        _log = LogFactoryUtil.getLog(IngresDB.class);
        _instance = new IngresDB();
    }
}

