/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDB
extends BaseDB {
    private static String[] _MYSQL = new String[]{"##", "1", "0", "'1970-01-01'", "now()", " blob", " tinyint", " datetime", " double", " integer", " bigint", " longtext", " longtext", " varchar", "  auto_increment", "commit"};
    private static boolean _SUPPORTS_DATE_MILLISECONDS = false;
    private static boolean _SUPPORTS_UPDATE_WITH_INNER_JOIN = true;
    private static MySQLDB _instance = new MySQLDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes() throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("select distinct(index_name), table_name, non_unique ");
            sb.append("from information_schema.statistics where ");
            sb.append("index_schema = database() and (index_name like ");
            sb.append("'LIFERAY_%' or index_name like 'IX_%')");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                String tableName = rs.getString("table_name");
                boolean unique = !rs.getBoolean("non_unique");
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsDateMilliseconds() {
        return _SUPPORTS_DATE_MILLISECONDS;
    }

    @Override
    public boolean isSupportsUpdateWithInnerJoin() {
        return _SUPPORTS_UPDATE_WITH_INNER_JOIN;
    }

    protected MySQLDB() {
        super("mysql");
    }

    @Override
    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb.append("drop database if exists " + databaseName + ";\n");
        sb.append("create database " + databaseName + " character set utf8;\n");
        sb.append("use ");
        sb.append(databaseName);
        sb.append(";\n\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-mysql.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-mysql.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-mysql.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "mysql";
    }

    @Override
    protected String[] getTemplate() {
        return _MYSQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        boolean createTable = false;
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (StringUtil.startsWith((String)line, (String)"create table")) {
                createTable = true;
            } else if (line.startsWith(ALTER_COLUMN_NAME)) {
                String[] template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ change column @old-column@ @new-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                String[] template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            }
            int pos = line.indexOf(";");
            if (createTable && pos != -1) {
                createTable = false;
                line = line.substring(0, pos) + " engine " + PropsValues.DATABASE_MYSQL_ENGINE + line.substring(pos);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

